<x-admin-layout>
    <x-slot name="header">
        Create New Invoice
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <form method="POST" action="{{ route('admin.finance.store') }}">
            @csrf

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Invoice Details</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Customer -->
                        <div>
                            <label for="customer_id" class="block text-sm font-medium text-gray-700">Customer</label>
                            <select name="customer_id" id="customer_id" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="">Select Customer</option>
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>{{ $customer->name }} ({{ $customer->email }})</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Type -->
                        <div>
                            <label for="type" class="block text-sm font-medium text-gray-700">Type</label>
                            <select name="type" id="type" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="SERVICE" {{ old('type') == 'SERVICE' ? 'selected' : '' }}>Service</option>
                                <option value="SALE" {{ old('type') == 'SALE' ? 'selected' : '' }}>Vehicle Sales</option>
                                <option value="PARTS" {{ old('type') == 'PARTS' ? 'selected' : '' }}>Parts</option>
                            </select>
                        </div>

                        <!-- Issue Date -->
                        <div>
                            <label for="issue_date" class="block text-sm font-medium text-gray-700">Issue Date</label>
                            <input type="date" name="issue_date" id="issue_date" value="{{ old('issue_date', date('Y-m-d')) }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Due Date -->
                        <div>
                            <label for="due_date" class="block text-sm font-medium text-gray-700">Due Date</label>
                            <input type="date" name="due_date" id="due_date" value="{{ old('due_date', date('Y-m-d', strtotime('+7 days'))) }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Items</h3>
                        <button type="button" id="add-item" class="px-3 py-1 bg-gray-100 text-gray-700 rounded hover:bg-gray-200 text-sm">Add Item</button>
                    </div>
                    
                    <div id="items-container" class="space-y-4">
                        <div class="grid grid-cols-12 gap-4 item-row">
                            <div class="col-span-12 md:col-span-5">
                                <input type="text" name="items[0][description]" placeholder="Description" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div class="col-span-4 md:col-span-2">
                                <input type="number" name="items[0][quantity]" placeholder="Qty" value="1" min="1" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div class="col-span-4 md:col-span-2">
                                <input type="number" name="items[0][unit_price]" placeholder="Price" min="0" step="0.01" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div class="col-span-4 md:col-span-2">
                                <input type="number" name="items[0][tax_rate]" placeholder="Tax %" value="14" min="0" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                            </div>
                            <div class="col-span-12 md:col-span-1 flex items-center justify-center">
                                <button type="button" class="text-red-500 hover:text-red-700 remove-item" disabled>&times;</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                     <div class="grid grid-cols-1 gap-6">
                        <!-- Notes -->
                        <div>
                            <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                            <textarea name="notes" id="notes" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('notes') }}</textarea>
                        </div>

                         <!-- Terms -->
                        <div>
                            <label for="terms" class="block text-sm font-medium text-gray-700">Terms & Conditions</label>
                            <textarea name="terms" id="terms" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('terms') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <a href="{{ route('admin.finance.index') }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none mr-4">Cancel</a>
                <button type="submit" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none">Create Invoice</button>
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let itemIndex = 1;
            const container = document.getElementById('items-container');
            const addButton = document.getElementById('add-item');

            addButton.addEventListener('click', function() {
                const row = document.createElement('div');
                row.className = 'grid grid-cols-12 gap-4 item-row mt-4';
                row.innerHTML = `
                    <div class="col-span-12 md:col-span-5">
                        <input type="text" name="items[${itemIndex}][description]" placeholder="Description" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="col-span-4 md:col-span-2">
                        <input type="number" name="items[${itemIndex}][quantity]" placeholder="Qty" value="1" min="1" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="col-span-4 md:col-span-2">
                        <input type="number" name="items[${itemIndex}][unit_price]" placeholder="Price" min="0" step="0.01" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="col-span-4 md:col-span-2">
                        <input type="number" name="items[${itemIndex}][tax_rate]" placeholder="Tax %" value="14" min="0" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                    <div class="col-span-12 md:col-span-1 flex items-center justify-center">
                         <button type="button" class="text-red-500 hover:text-red-700 remove-item">&times;</button>
                    </div>
                `;
                container.appendChild(row);
                itemIndex++;
            });

            container.addEventListener('click', function(e) {
                if (e.target.classList.contains('remove-item')) {
                    e.target.closest('.item-row').remove();
                }
            });
        });
    </script>
</x-admin-layout>
