<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الفواتير</h2>
            <p class="text-slate-500 text-sm">إدارة الفواتير والمستحقات المالية</p>
        </div>
        <a href="{{ route('admin.finance.create') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
            <x-icon name="Plus" class="h-4 w-4" />
            <span>إنشاء فاتورة جديدة</span>
        </a>
    </div>

    <div class="mb-6 rounded-2xl bg-white p-4 shadow-sm border border-slate-100">
        <form method="GET" action="{{ route('admin.finance.index') }}" class="flex flex-col md:flex-row items-center gap-4">
            <div class="relative flex-1 w-full">
                <x-icon name="Search" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" />
                <input type="text" name="search" placeholder="ابحث برقم الفاتورة أو اسم العميل..." value="{{ request('search') }}" class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500">
            </div>
            <div class="w-full md:w-48">
                <select name="status" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                    <option value="all">جميع الحالات</option>
                    <option value="DRAFT" {{ request('status') == 'DRAFT' ? 'selected' : '' }}>مسودة</option>
                    <option value="SENT" {{ request('status') == 'SENT' ? 'selected' : '' }}>مرسلة</option>
                    <option value="PAID" {{ request('status') == 'PAID' ? 'selected' : '' }}>مدفوعة</option>
                    <option value="PARTIALLY_PAID" {{ request('status') == 'PARTIALLY_PAID' ? 'selected' : '' }}>مدفوعة جزئياً</option>
                    <option value="OVERDUE" {{ request('status') == 'OVERDUE' ? 'selected' : '' }}>متأخرة</option>
                    <option value="CANCELLED" {{ request('status') == 'CANCELLED' ? 'selected' : '' }}>ملغاة</option>
                </select>
            </div>
            <button type="submit" class="w-full md:w-auto inline-flex items-center justify-center rounded-xl bg-slate-800 px-6 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-slate-700 transition-all">
                <x-icon name="Filter" class="ml-2 h-4 w-4" />
                تصفية
            </button>
        </form>
    </div>

    <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">رقم الفاتورة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">العميل</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">التاريخ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">المبلغ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($invoices as $invoice)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <a href="{{ route('admin.finance.show', $invoice->id) }}" class="text-blue-600 font-bold hover:text-blue-800 font-mono">
                                    {{ $invoice->invoice_number }}
                                </a>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold text-slate-900">{{ $invoice->customer->name ?? 'غير محدد' }}</div>
                                <div class="text-xs text-slate-500">{{ $invoice->customer->email ?? '' }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500">
                                <div class="flex items-center gap-2">
                                    <x-icon name="Calendar" class="h-4 w-4 text-slate-400" />
                                    <span>{{ $invoice->issue_date->format('Y-m-d') }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold text-slate-900">{{ number_format($invoice->total_amount, 2) }} ج.م</div>
                                @if($invoice->paid_amount > 0)
                                    <div class="text-xs text-emerald-600 mt-1">مدفوع: {{ number_format($invoice->paid_amount, 2) }}</div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                    {{ $invoice->status === 'PAID' ? 'bg-emerald-100 text-emerald-700' : 
                                       ($invoice->status === 'PARTIALLY_PAID' ? 'bg-blue-100 text-blue-700' : 
                                       ($invoice->status === 'OVERDUE' ? 'bg-red-100 text-red-700' : 
                                       ($invoice->status === 'SENT' ? 'bg-indigo-100 text-indigo-700' : 
                                       ($invoice->status === 'CANCELLED' ? 'bg-slate-100 text-slate-700' : 'bg-gray-100 text-gray-700')))) }}">
                                    {{ $invoice->status === 'PAID' ? 'مدفوعة' : 
                                       ($invoice->status === 'PARTIALLY_PAID' ? 'مدفوعة جزئياً' : 
                                       ($invoice->status === 'OVERDUE' ? 'متأخرة' : 
                                       ($invoice->status === 'SENT' ? 'مرسلة' : 
                                       ($invoice->status === 'CANCELLED' ? 'ملغاة' : 'مسودة')))) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                <a href="{{ route('admin.finance.show', $invoice->id) }}" class="inline-flex items-center gap-2 px-3 py-1.5 bg-slate-100 text-slate-700 rounded-lg hover:bg-slate-200 transition-colors">
                                    <x-icon name="Eye" class="h-4 w-4" />
                                    <span>عرض</span>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="FileText" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد فواتير</p>
                                    <p class="text-sm">لم يتم العثور على أي فواتير في النظام.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="border-t border-gray-100 bg-gray-50/50 p-4">
            {{ $invoices->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
