<x-admin-layout>
    <x-slot name="header">
        Invoice #{{ $invoice->invoice_number }}
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Invoice Details</h3>
                    <p class="mt-1 max-w-2xl text-sm text-gray-500">Issued on {{ $invoice->issue_date->format('M d, Y') }}</p>
                </div>
                <div class="flex space-x-2">
                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $invoice->status === 'PAID' ? 'bg-green-100 text-green-800' : 
                           ($invoice->status === 'PARTIALLY_PAID' ? 'bg-yellow-100 text-yellow-800' : 
                           ($invoice->status === 'OVERDUE' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')) }}">
                        {{ str_replace('_', ' ', $invoice->status) }}
                    </span>
                    <a href="#" onclick="window.print()" class="px-3 py-1 bg-gray-600 text-white rounded text-sm hover:bg-gray-700">Print</a>
                </div>
            </div>
            <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <h4 class="text-sm font-medium text-gray-500 uppercase tracking-wider mb-2">From</h4>
                        <div class="text-gray-900 font-bold">{{ $invoice->branch->name ?? 'Elhamd Auto' }}</div>
                        <div class="text-gray-600 text-sm">
                            {{ $invoice->branch->address ?? '123 Main St, Cairo, Egypt' }}<br>
                            Phone: {{ $invoice->branch->phone ?? '+20 123 456 7890' }}
                        </div>
                    </div>
                    <div>
                        <h4 class="text-sm font-medium text-gray-500 uppercase tracking-wider mb-2">To</h4>
                        <div class="text-gray-900 font-bold">{{ $invoice->customer->name }}</div>
                        <div class="text-gray-600 text-sm">
                            {{ $invoice->customer->email }}<br>
                            {{ $invoice->customer->phone ?? '' }}
                        </div>
                    </div>
                </div>

                <table class="min-w-full divide-y divide-gray-200 mb-6">
                    <thead>
                        <tr>
                            <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                            <th class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Qty</th>
                            <th class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                            <th class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Tax</th>
                            <th class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($invoice->items as $item)
                        <tr>
                            <td class="px-3 py-2 text-sm text-gray-900">{{ $item->description }}</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ $item->quantity }}</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($item->unit_price, 2) }}</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($item->tax_amount, 2) }} ({{ $item->tax_rate }}%)</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($item->total_price + $item->tax_amount, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="4" class="px-3 py-2 text-right text-sm font-medium text-gray-900">Subtotal</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($invoice->subtotal, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="4" class="px-3 py-2 text-right text-sm font-medium text-gray-900">Tax</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($invoice->tax_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="4" class="px-3 py-2 text-right text-sm font-bold text-gray-900">Total</td>
                            <td class="px-3 py-2 text-right text-sm font-bold text-gray-900">{{ number_format($invoice->total_amount, 2) }} EGP</td>
                        </tr>
                         <tr>
                            <td colspan="4" class="px-3 py-2 text-right text-sm font-medium text-gray-900">Paid Amount</td>
                            <td class="px-3 py-2 text-right text-sm text-green-600">{{ number_format($invoice->paid_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="4" class="px-3 py-2 text-right text-sm font-bold text-gray-900">Balance Due</td>
                            <td class="px-3 py-2 text-right text-sm font-bold text-red-600">{{ number_format($invoice->total_amount - $invoice->paid_amount, 2) }} EGP</td>
                        </tr>
                    </tfoot>
                </table>

                @if($invoice->notes)
                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-500">Notes</h4>
                    <p class="text-sm text-gray-600">{{ $invoice->notes }}</p>
                </div>
                @endif
            </div>
        </div>

        <!-- Payments Section -->
        <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
            <div class="px-4 py-5 sm:p-6">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Record Payment</h3>
                
                @if($invoice->total_amount - $invoice->paid_amount > 0)
                <form method="POST" action="{{ route('admin.finance.payments.store') }}" class="mb-6">
                    @csrf
                    <input type="hidden" name="customer_id" value="{{ $invoice->customer_id }}">
                    <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                    
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div class="md:col-span-1">
                            <label for="amount" class="block text-sm font-medium text-gray-700">Amount</label>
                            <input type="number" name="amount" id="amount" step="0.01" min="0.01" max="{{ $invoice->total_amount - $invoice->paid_amount }}" value="{{ $invoice->total_amount - $invoice->paid_amount }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                        <div class="md:col-span-1">
                            <label for="payment_method" class="block text-sm font-medium text-gray-700">Method</label>
                            <select name="payment_method" id="payment_method" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="CASH">Cash</option>
                                <option value="CREDIT_CARD">Credit Card</option>
                                <option value="BANK_TRANSFER">Bank Transfer</option>
                                <option value="CHECK">Check</option>
                            </select>
                        </div>
                        <div class="md:col-span-1">
                            <label for="transaction_id" class="block text-sm font-medium text-gray-700">Transaction ID</label>
                            <input type="text" name="transaction_id" id="transaction_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                        <div class="md:col-span-1 flex items-end">
                            <button type="submit" class="w-full bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">Add Payment</button>
                        </div>
                    </div>
                </form>
                @else
                <div class="bg-green-50 p-4 rounded-md mb-6">
                    <p class="text-green-700 text-sm">This invoice is fully paid.</p>
                </div>
                @endif

                @if($invoice->payments->isNotEmpty())
                <h4 class="text-sm font-medium text-gray-900 mb-2">Payment History</h4>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Method</th>
                            <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                            <th class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($invoice->payments as $payment)
                        <tr>
                            <td class="px-3 py-2 text-sm text-gray-900">{{ $payment->created_at->format('M d, Y') }}</td>
                            <td class="px-3 py-2 text-sm text-gray-900">{{ str_replace('_', ' ', $payment->payment_method) }}</td>
                            <td class="px-3 py-2 text-sm text-gray-900">{{ $payment->transaction_id }}</td>
                            <td class="px-3 py-2 text-right text-sm text-gray-900">{{ number_format($payment->amount, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @endif
            </div>
        </div>

        <div class="flex justify-end">
            <a href="{{ route('admin.finance.index') }}" class="text-gray-600 hover:text-gray-900">Back to List</a>
        </div>
    </div>
</x-admin-layout>
