<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">سجل المدفوعات</h2>
            <p class="text-slate-500 text-sm">متابعة جميع عمليات الدفع والتحويلات المالية</p>
        </div>
    </div>

    <div class="mb-6 rounded-2xl bg-white p-4 shadow-sm border border-slate-100">
        <form method="GET" action="{{ route('admin.finance.payments.index') }}" class="flex flex-col md:flex-row items-center gap-4">
            <div class="relative flex-1 w-full">
                <x-icon name="Search" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" />
                <input type="text" name="search" placeholder="ابحث برقم المعاملة أو اسم العميل..." value="{{ request('search') }}" class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500">
            </div>
            <button type="submit" class="w-full md:w-auto inline-flex items-center justify-center rounded-xl bg-slate-800 px-6 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-slate-700 transition-all">
                <x-icon name="Filter" class="ml-2 h-4 w-4" />
                بحث
            </button>
        </form>
    </div>

    <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">رقم المعاملة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">العميل</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">التاريخ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">طريقة الدفع</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الفاتورة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">المبلغ</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($payments as $payment)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-slate-900 font-mono">
                                {{ $payment->transaction_id }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm font-bold text-slate-800">{{ $payment->customer->name ?? 'غير محدد' }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500">
                                <div class="flex items-center gap-2">
                                    <x-icon name="Clock" class="h-4 w-4 text-slate-400" />
                                    <span>{{ $payment->created_at->format('Y-m-d H:i') }}</span>
                                </div>
                            </td>
                             <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-lg text-xs font-medium bg-slate-100 text-slate-700">
                                    <x-icon name="CreditCard" class="h-3 w-3" />
                                    {{ str_replace('_', ' ', $payment->payment_method) }}
                                </span>
                            </td>
                             <td class="px-6 py-4 whitespace-nowrap text-sm text-blue-600 font-medium">
                                @if($payment->invoice)
                                    <a href="{{ route('admin.finance.show', $payment->invoice->id) }}" class="hover:underline">
                                        #{{ $payment->invoice->invoice_number }}
                                    </a>
                                @else
                                    <span class="text-gray-400">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-bold text-emerald-600">
                                {{ number_format($payment->amount, 2) }} ج.م
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="DollarSign" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد مدفوعات</p>
                                    <p class="text-sm">لم يتم تسجيل أي عمليات دفع بعد.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="border-t border-gray-100 bg-gray-50/50 p-4">
            {{ $payments->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
