<x-admin-layout>
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-slate-800">استلام منتجات</h2>
        <p class="text-slate-500 text-sm">استلام منتجات لأمر الشراء: {{ $purchaseOrder->order_number }}</p>
    </div>

    <form action="{{ route('purchase-orders.receive.store', $purchaseOrder->id) }}" method="POST">
        @csrf

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6 mb-6">
            <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">تفاصيل الاستلام</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Received Date -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">تاريخ الاستلام <span class="text-red-500">*</span></label>
                    <input type="date" name="received_date" value="{{ date('Y-m-d') }}" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Notes -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">ملاحظات الاستلام</label>
                    <input type="text" name="notes" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6 mb-6">
            <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">المنتجات</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">المنتج</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الكمية المطلوبة</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">تم استلامه</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">المتبقي</th>
                            <th class="px-4 py-2 text-right text-xs font-bold text-blue-600 uppercase w-32">استلام الآن</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">ملاحظات الصنف</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($purchaseOrder->items as $item)
                            @php
                                $remaining = $item->quantity_ordered - $item->quantity_received;
                            @endphp
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="px-4 py-3 text-sm text-slate-700">{{ $item->product->name ?? 'منتج غير معروف' }}</td>
                                <td class="px-4 py-3 text-sm text-slate-700 font-medium">{{ $item->quantity_ordered }}</td>
                                <td class="px-4 py-3 text-sm text-slate-500">{{ $item->quantity_received }}</td>
                                <td class="px-4 py-3 text-sm text-slate-700 font-bold {{ $remaining > 0 ? 'text-orange-600' : 'text-green-600' }}">{{ $remaining }}</td>
                                <td class="px-4 py-3">
                                    <input type="number" name="items[{{ $item->id }}][received_qty]" value="{{ $remaining > 0 ? $remaining : 0 }}" min="0" max="{{ $remaining }}" class="w-full text-sm rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500 font-bold text-blue-700">
                                </td>
                                <td class="px-4 py-3">
                                    <input type="text" name="items[{{ $item->id }}][notes]" placeholder="ملاحظات..." class="w-full text-sm rounded-lg border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="flex justify-end gap-4">
            <a href="{{ route('admin.purchase-orders.show', $purchaseOrder->id) }}" class="px-6 py-2.5 rounded-xl border border-gray-200 text-gray-700 font-semibold hover:bg-gray-50 transition-colors">إلغاء</a>
            <button type="submit" class="px-6 py-2.5 rounded-xl bg-blue-600 text-white font-semibold hover:bg-blue-700 transition-colors shadow-sm">
                تأكيد الاستلام
            </button>
        </div>
    </form>
</x-admin-layout>
