<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">سجل الحضور والانصراف</h2>
            <p class="text-slate-500 text-sm">متابعة حضور الموظفين وساعات العمل</p>
        </div>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
        <div class="p-4 border-b border-slate-100 bg-slate-50/50">
            <form method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="flex-1 relative">
                    <x-icon name="Search" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-slate-400" />
                    <input type="text" name="search" placeholder="بحث باسم الموظف..." value="{{ request('search') }}" 
                           class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500 text-sm">
                </div>
                <div class="w-full md:w-48">
                    <input type="date" name="date" value="{{ request('date') }}" 
                           class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm text-slate-600">
                </div>
                <div class="w-full md:w-48">
                    <select name="status" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm text-slate-600">
                        <option value="">كل الحالات</option>
                        <option value="PRESENT" {{ request('status') == 'PRESENT' ? 'selected' : '' }}>حاضر</option>
                        <option value="ABSENT" {{ request('status') == 'ABSENT' ? 'selected' : '' }}>غائب</option>
                        <option value="LATE" {{ request('status') == 'LATE' ? 'selected' : '' }}>متأخر</option>
                        <option value="ON_LEAVE" {{ request('status') == 'ON_LEAVE' ? 'selected' : '' }}>في إجازة</option>
                    </select>
                </div>
                <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 bg-slate-800 text-white rounded-xl hover:bg-slate-700 transition-colors text-sm font-medium shadow-sm">
                    <x-icon name="Filter" class="h-4 w-4" />
                    <span>تصفية</span>
                </button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الموظف</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">التاريخ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">تسجيل الدخول</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">تسجيل الخروج</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">ساعات العمل</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($records as $rec)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-3">
                                    <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 font-bold text-xs uppercase">
                                        {{ substr($rec->employee->first_name ?? 'U', 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-slate-900">{{ $rec->employee->first_name ?? '' }} {{ $rec->employee->last_name ?? '' }}</div>
                                        <div class="text-xs text-slate-500">{{ $rec->employee->job_title ?? 'موظف' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-700 font-medium">{{ $rec->date->format('Y/m/d') }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm font-mono text-slate-600 bg-slate-100 px-2 py-1 rounded">{{ $rec->check_in ? date('H:i', strtotime($rec->check_in)) : '-' }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm font-mono text-slate-600 bg-slate-100 px-2 py-1 rounded">{{ $rec->check_out ? date('H:i', strtotime($rec->check_out)) : '-' }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                    {{ $rec->status === 'PRESENT' ? 'bg-emerald-100 text-emerald-700' : 
                                       ($rec->status === 'ABSENT' ? 'bg-red-100 text-red-700' : 
                                       ($rec->status === 'LATE' ? 'bg-amber-100 text-amber-700' : 
                                       ($rec->status === 'ON_LEAVE' ? 'bg-blue-100 text-blue-700' : 'bg-gray-100 text-gray-700'))) }}">
                                    {{ $rec->status === 'PRESENT' ? 'حاضر' : 
                                       ($rec->status === 'ABSENT' ? 'غائب' : 
                                       ($rec->status === 'LATE' ? 'متأخر' : 
                                       ($rec->status === 'ON_LEAVE' ? 'في إجازة' : $rec->status))) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($rec->check_in && $rec->check_out)
                                    @php
                                        $in = \Carbon\Carbon::parse($rec->check_in);
                                        $out = \Carbon\Carbon::parse($rec->check_out);
                                        $duration = $out->diff($in);
                                    @endphp
                                    <span class="text-sm font-mono text-slate-700">{{ $duration->format('%H:%I') }} ساعة</span>
                                @else
                                    <span class="text-sm text-slate-400">-</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="Calendar" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد سجلات حضور</p>
                                    <p class="text-sm">لم يتم العثور على بيانات تطابق بحثك.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 bg-slate-50 border-t border-slate-100">
            {{ $records->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
