<x-admin-layout>
    <div x-data="{ createDepartmentModalOpen: false }">
        <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
            <div>
                <h2 class="text-2xl font-bold text-slate-800">الأقسام والإدارات</h2>
                <p class="text-slate-500 text-sm">إدارة الهيكل التنظيمي للشركة</p>
            </div>
            <button @click="createDepartmentModalOpen = true" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
                <x-icon name="Plus" class="h-4 w-4" />
                <span>إضافة قسم جديد</span>
            </button>
        </div>

        <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">اسم القسم</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الوصف</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">عدد الموظفين</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($departments as $dept)
                            <tr class="hover:bg-slate-50/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center gap-3">
                                        <div class="h-8 w-8 rounded-lg bg-blue-50 text-blue-600 flex items-center justify-center">
                                            <x-icon name="Building" class="h-4 w-4" />
                                        </div>
                                        <span class="text-sm font-bold text-slate-900">{{ $dept->name }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-slate-500 max-w-xs truncate">{{ $dept->description ?? '-' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-slate-100 text-slate-800">
                                        {{ $dept->employees_count ?? $dept->employees->count() ?? 0 }} موظف
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                        {{ $dept->is_active ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                                        {{ $dept->is_active ? 'نشط' : 'غير نشط' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                    <div class="flex items-center justify-end gap-2">
                                        <button class="p-2 bg-slate-100 text-slate-600 rounded-lg hover:bg-slate-200 transition-colors" title="تعديل">
                                            <x-icon name="Edit" class="h-4 w-4" />
                                        </button>
                                        <form action="{{ route('admin.hr.departments.destroy', $dept->id) }}" method="POST" class="inline-block" onsubmit="return confirm('هل أنت متأكد من حذف هذا القسم؟');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                                <x-icon name="Trash" class="h-4 w-4" />
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-slate-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                            <x-icon name="Building" class="h-8 w-8 text-slate-300" />
                                        </div>
                                        <p class="text-lg font-medium">لا توجد أقسام</p>
                                        <p class="text-sm">قم بإضافة أقسام جديدة لتنظيم الهيكل الوظيفي.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Create Department Modal -->
        <div x-show="createDepartmentModalOpen" 
             style="display: none;"
             class="fixed inset-0 z-50 overflow-y-auto" 
             aria-labelledby="modal-title" 
             role="dialog" 
             aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="createDepartmentModalOpen" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                     @click="createDepartmentModalOpen = false"
                     aria-hidden="true"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="createDepartmentModalOpen" 
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     class="inline-block align-bottom bg-white rounded-2xl text-right overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                    
                    <div class="bg-white p-6">
                        <div class="flex items-center justify-between mb-5">
                            <h3 class="text-xl font-bold text-slate-800" id="modal-title">إضافة قسم جديد</h3>
                            <button @click="createDepartmentModalOpen = false" class="text-slate-400 hover:text-slate-600 transition-colors">
                                <x-icon name="X" class="h-6 w-6" />
                            </button>
                        </div>
                        
                        <form action="{{ route('admin.hr.departments.store') }}" method="POST" class="space-y-4">
                            @csrf
                            
                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-1">اسم القسم</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                        <x-icon name="Building" class="h-5 w-5 text-slate-400" />
                                    </div>
                                    <input type="text" name="name" required 
                                           class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                           placeholder="أدخل اسم القسم">
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-1">الوصف</label>
                                <textarea name="description" rows="3" 
                                          class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                          placeholder="وصف مختصر لمهام القسم..."></textarea>
                            </div>
                            
                            <div class="mt-6 flex items-center gap-3">
                                <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors font-semibold shadow-sm">
                                    حفظ القسم
                                </button>
                                <button type="button" @click="createDepartmentModalOpen = false" class="px-4 py-2 bg-slate-100 text-slate-700 rounded-xl hover:bg-slate-200 transition-colors font-medium">
                                    إلغاء
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
