<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تفاصيل الموظف: {{ $employee->first_name }} {{ $employee->last_name }}</h2>
            <p class="text-slate-500 text-sm">عرض الملف الشخصي وسجل الحضور</p>
        </div>
        <a href="{{ route('admin.hr.employees.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-600 hover:bg-slate-50 hover:text-slate-800 transition-colors">
            <x-icon name="ArrowRight" class="h-4 w-4" />
            <span>عودة للقائمة</span>
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Basic Info Card -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden h-fit">
            <div class="p-6 border-b border-gray-50 flex flex-col items-center text-center">
                <div class="h-24 w-24 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 mb-4 ring-4 ring-blue-50/50">
                    <span class="text-3xl font-bold">{{ substr($employee->first_name, 0, 1) }}</span>
                </div>
                <h3 class="text-xl font-bold text-slate-800">{{ $employee->first_name }} {{ $employee->last_name }}</h3>
                <p class="text-slate-500 text-sm mb-2">{{ $employee->position->name ?? 'غير محدد' }}</p>
                <div class="flex items-center justify-center mt-2">
                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                        {{ $employee->status === 'ACTIVE' ? 'bg-emerald-100 text-emerald-700' : 
                           ($employee->status === 'ON_LEAVE' ? 'bg-blue-100 text-blue-700' : 
                           ($employee->status === 'TERMINATED' ? 'bg-red-100 text-red-700' : 'bg-amber-100 text-amber-700')) }}">
                        {{ $employee->status === 'ACTIVE' ? 'نشط' : 
                           ($employee->status === 'ON_LEAVE' ? 'في إجازة' : 
                           ($employee->status === 'TERMINATED' ? 'منتهي عقده' : 'موقف')) }}
                    </span>
                </div>
            </div>
            <div class="p-6">
                <h4 class="text-sm font-bold text-slate-900 mb-4 flex items-center gap-2">
                    <x-icon name="User" class="h-4 w-4 text-slate-400" />
                    المعلومات الشخصية
                </h4>
                <div class="space-y-4">
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">الرقم الوظيفي</label>
                        <div class="text-slate-800 font-medium font-mono text-lg">{{ $employee->employee_number }}</div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">البريد الإلكتروني</label>
                        <div class="text-slate-800 font-medium break-all">{{ $employee->email ?? '-' }}</div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">رقم الهاتف</label>
                        <div class="text-slate-800 font-medium dir-ltr text-right">{{ $employee->phone ?? '-' }}</div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">القسم</label>
                        <div class="text-slate-800 font-medium">{{ $employee->department->name ?? '-' }}</div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">تاريخ التعيين</label>
                         <div class="text-slate-800 font-medium">
                            {{ $employee->hire_date instanceof \Carbon\Carbon ? $employee->hire_date->format('Y-m-d') : $employee->hire_date }}
                        </div>
                    </div>
                    <div class="bg-slate-50 p-4 rounded-xl">
                        <label class="text-xs text-slate-400 block mb-1">الراتب الأساسي</label>
                        <div class="text-slate-800 font-bold text-emerald-600">{{ number_format($employee->salary, 2) }} ج.م</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attendance & Activity -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Attendance Summary -->
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-50 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                        <x-icon name="Clock" class="h-5 w-5 text-blue-600" />
                        سجلات الحضور الأخيرة
                    </h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-100">
                        <thead class="bg-gray-50/50">
                            <tr>
                                <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحضور</th>
                                <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الانصراف</th>
                                <th class="px-6 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @forelse($employee->attendanceRecords ?? collect([]) as $rec)
                                <tr class="hover:bg-slate-50/50">
                                    <td class="px-6 py-3 whitespace-nowrap text-sm text-slate-700">
                                        {{ $rec->date }}
                                    </td>
                                    <td class="px-6 py-3 whitespace-nowrap text-sm text-slate-600">
                                        {{ $rec->check_in ? \Carbon\Carbon::parse($rec->check_in)->format('H:i') : '-' }}
                                    </td>
                                    <td class="px-6 py-3 whitespace-nowrap text-sm text-slate-600">
                                        {{ $rec->check_out ? \Carbon\Carbon::parse($rec->check_out)->format('H:i') : '-' }}
                                    </td>
                                    <td class="px-6 py-3 whitespace-nowrap">
                                        <span class="px-2 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                            {{ $rec->status === 'PRESENT' ? 'bg-green-100 text-green-700' : 
                                               ($rec->status === 'ABSENT' ? 'bg-red-100 text-red-700' : 'bg-yellow-100 text-yellow-700') }}">
                                            {{ $rec->status === 'PRESENT' ? 'حضور' : 
                                               ($rec->status === 'ABSENT' ? 'غياب' : 'تأخير') }}
                                        </span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                        <div class="flex flex-col items-center justify-center">
                                            <div class="h-12 w-12 bg-slate-50 rounded-full flex items-center justify-center mb-3">
                                                <x-icon name="Calendar" class="h-6 w-6 text-slate-300" />
                                            </div>
                                            <p class="text-sm font-medium">لا توجد سجلات حضور</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
