<x-admin-layout>
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الموارد البشرية</h2>
            <p class="text-slate-500 text-sm">نظرة عامة على الموظفين، الحضور، والرواتب</p>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-8">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-blue-50 text-blue-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="Users" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['total_employees'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">إجمالي الموظفين</div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-emerald-50 text-emerald-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="CheckCircle" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['active'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">نشط حالياً</div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-purple-50 text-purple-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="Building" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['departments'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">الأقسام</div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-amber-50 text-amber-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="Sun" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['on_leave'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">في إجازة</div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-red-50 text-red-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="ClipboardList" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['pending_reviews'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">مراجعات معلقة</div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-4 flex flex-col items-center justify-center text-center hover:shadow-md transition-shadow">
            <div class="h-10 w-10 bg-teal-50 text-teal-600 rounded-full flex items-center justify-center mb-3">
                <x-icon name="AcademicCap" class="h-5 w-5" />
            </div>
            <div class="text-2xl font-bold text-slate-800">{{ $stats['training_this_month'] }}</div>
            <div class="text-xs text-slate-500 font-medium mt-1">تدريب (هذا الشهر)</div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Quick Links Card -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
            <h3 class="text-lg font-bold text-slate-800 mb-4 flex items-center gap-2">
                <x-icon name="Link" class="h-5 w-5 text-slate-400" />
                روابط سريعة
            </h3>
            <div class="grid grid-cols-1 gap-3">
                <a href="{{ route('admin.hr.employees.index') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-blue-50 transition-colors border border-transparent hover:border-blue-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-blue-600 group-hover:scale-110 transition-transform">
                            <x-icon name="Users" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-blue-700">إدارة الموظفين</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-blue-500" />
                </a>

                <a href="{{ route('admin.hr.attendance') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-emerald-50 transition-colors border border-transparent hover:border-emerald-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-emerald-600 group-hover:scale-110 transition-transform">
                            <x-icon name="Clock" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-emerald-700">سجل الحضور</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-emerald-500" />
                </a>

                <a href="{{ route('admin.hr.departments') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-purple-50 transition-colors border border-transparent hover:border-purple-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-purple-600 group-hover:scale-110 transition-transform">
                            <x-icon name="Building" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-purple-700">الأقسام والإدارات</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-purple-500" />
                </a>

                 <a href="{{ route('admin.hr.leaves') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-amber-50 transition-colors border border-transparent hover:border-amber-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-amber-600 group-hover:scale-110 transition-transform">
                            <x-icon name="Sun" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-amber-700">إدارة الإجازات</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-amber-500" />
                </a>

                <a href="{{ route('admin.hr.payroll') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-indigo-50 transition-colors border border-transparent hover:border-indigo-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-indigo-600 group-hover:scale-110 transition-transform">
                            <x-icon name="Banknotes" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-indigo-700">الرواتب والأجور</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-indigo-500" />
                </a>

                <a href="{{ route('admin.hr.performance') }}" class="group flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-red-50 transition-colors border border-transparent hover:border-red-100">
                    <div class="flex items-center gap-3">
                        <div class="h-8 w-8 bg-white rounded-lg flex items-center justify-center shadow-sm text-red-600 group-hover:scale-110 transition-transform">
                            <x-icon name="ChartBar" class="h-4 w-4" />
                        </div>
                        <span class="font-medium text-slate-700 group-hover:text-red-700">تقييم الأداء</span>
                    </div>
                    <x-icon name="ChevronLeft" class="h-4 w-4 text-slate-400 group-hover:text-red-500" />
                </a>
            </div>
        </div>

        <!-- Recent Activity / Placeholder -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6 md:col-span-1 lg:col-span-2">
            <h3 class="text-lg font-bold text-slate-800 mb-4 flex items-center gap-2">
                <x-icon name="Bell" class="h-5 w-5 text-slate-400" />
                آخر التحديثات
            </h3>
            <div class="flex flex-col items-center justify-center h-64 text-center">
                <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                    <x-icon name="ClipboardDocumentCheck" class="h-8 w-8 text-slate-300" />
                </div>
                <p class="text-slate-500 font-medium">لا توجد تحديثات حديثة</p>
                <p class="text-slate-400 text-sm mt-1">سجل النشاطات سيظهر هنا عند توفره.</p>
            </div>
        </div>
    </div>
</x-admin-layout>
