<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الإجازات</h2>
            <p class="text-slate-500 text-sm">مراجعة ومعالجة طلبات الإجازة للموظفين</p>
        </div>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
        <div class="p-4 border-b border-slate-100 bg-slate-50/50">
            <form method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="w-full md:w-64">
                    <select name="status" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm text-slate-600">
                        <option value="all">كل الحالات</option>
                        @foreach(['PENDING' => 'معلق', 'APPROVED' => 'مقبول', 'REJECTED' => 'مرفوض'] as $val => $label)
                            <option value="{{ $val }}" {{ request('status') == $val ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 bg-slate-800 text-white rounded-xl hover:bg-slate-700 transition-colors text-sm font-medium shadow-sm">
                    <x-icon name="Filter" class="h-4 w-4" />
                    <span>تصفية</span>
                </button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الموظف</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">نوع الإجازة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">من تاريخ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">إلى تاريخ</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">المدة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($leaves as $leave)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-3">
                                    <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 font-bold text-xs uppercase">
                                        {{ substr($leave->employee->first_name ?? 'U', 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-slate-900">{{ $leave->employee->first_name ?? '' }} {{ $leave->employee->last_name ?? '' }}</div>
                                        <div class="text-xs text-slate-500">{{ $leave->employee->job_title ?? 'موظف' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-700 bg-slate-100 px-2 py-1 rounded">{{ $leave->type }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-600 font-medium">{{ $leave->start_date->format('Y/m/d') }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-600 font-medium">{{ $leave->end_date->format('Y/m/d') }}</span>
                            </td>
                             <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-600 font-mono">{{ $leave->start_date->diffInDays($leave->end_date) + 1 }} يوم</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                    {{ $leave->status === 'APPROVED' ? 'bg-emerald-100 text-emerald-700' : 
                                       ($leave->status === 'REJECTED' ? 'bg-red-100 text-red-700' : 'bg-amber-100 text-amber-700') }}">
                                    {{ $leave->status === 'APPROVED' ? 'مقبول' : 
                                       ($leave->status === 'REJECTED' ? 'مرفوض' : 'معلق') }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                @if($leave->status === 'PENDING')
                                    <div class="flex items-center justify-end gap-2">
                                        <form method="POST" action="{{ route('admin.hr.leaves.action', $leave->id) }}">
                                            @csrf @method('PATCH')
                                            <input type="hidden" name="action" value="approve">
                                            <button type="submit" class="p-1 px-3 bg-emerald-50 text-emerald-600 rounded-lg hover:bg-emerald-100 transition-colors text-xs font-bold border border-emerald-200">
                                                قبول
                                            </button>
                                        </form>
                                        <form method="POST" action="{{ route('admin.hr.leaves.action', $leave->id) }}">
                                            @csrf @method('PATCH')
                                            <input type="hidden" name="action" value="reject">
                                            <button type="submit" class="p-1 px-3 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors text-xs font-bold border border-red-200">
                                                رفض
                                            </button>
                                        </form>
                                    </div>
                                @else
                                    <span class="text-slate-400 text-xs">-</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="Sun" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد طلبات إجازة</p>
                                    <p class="text-sm">لم يتم العثور على طلبات إجازة تطابق بحثك.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 bg-slate-50 border-t border-slate-100">
            {{ $leaves->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
