<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تقييم الأداء</h2>
            <p class="text-slate-500 text-sm">مراجعة وتتبع أداء الموظفين</p>
        </div>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
        <div class="p-4 border-b border-slate-100 bg-slate-50/50">
            <form method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="w-full md:w-64">
                    <select name="status" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 text-sm text-slate-600">
                        <option value="all">كل الحالات</option>
                        @foreach(['DRAFT' => 'مسودة', 'PENDING' => 'معلق', 'COMPLETED' => 'مكتمل'] as $val => $label)
                            <option value="{{ $val }}" {{ request('status') == $val ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 bg-slate-800 text-white rounded-xl hover:bg-slate-700 transition-colors text-sm font-medium shadow-sm">
                    <x-icon name="Filter" class="h-4 w-4" />
                    <span>تصفية</span>
                </button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الموظف</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الفترة</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">تاريخ التقييم</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">التقييم العام</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($reviews as $review)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-3">
                                    <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 font-bold text-xs uppercase">
                                        {{ substr($review->employee->first_name ?? 'U', 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-slate-900">{{ $review->employee->first_name ?? '' }} {{ $review->employee->last_name ?? '' }}</div>
                                        <div class="text-xs text-slate-500">{{ $review->employee->job_title ?? 'موظف' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-700 bg-slate-100 px-2 py-1 rounded">{{ $review->period }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="text-sm text-slate-600 font-medium">{{ $review->review_date->format('Y/m/d') }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-1">
                                    @for($i = 1; $i <= 5; $i++)
                                        <x-icon name="Star" 
                                            class="h-4 w-4 {{ $i <= $review->overall_rating ? 'text-amber-400 fill-current' : 'text-slate-200' }}" />
                                    @endfor
                                    <span class="mr-2 text-xs font-bold text-slate-600">({{ $review->overall_rating }})</span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                                    {{ $review->status === 'COMPLETED' ? 'bg-emerald-100 text-emerald-700' : 
                                       ($review->status === 'PENDING' ? 'bg-amber-100 text-amber-700' : 'bg-gray-100 text-gray-700') }}">
                                    {{ $review->status === 'COMPLETED' ? 'مكتمل' : 
                                       ($review->status === 'PENDING' ? 'معلق' : 'مسودة') }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                                <div class="flex items-center justify-end gap-2">
                                     <button class="p-2 bg-slate-100 text-slate-600 rounded-lg hover:bg-slate-200 transition-colors" title="عرض التفاصيل">
                                        <x-icon name="Eye" class="h-4 w-4" />
                                    </button>
                                     <button class="p-2 bg-slate-100 text-slate-600 rounded-lg hover:bg-slate-200 transition-colors" title="تعديل">
                                        <x-icon name="Edit" class="h-4 w-4" />
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="ChartBar" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد تقييمات</p>
                                    <p class="text-sm">لم يتم العثور على تقييمات أداء تطابق بحثك.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 bg-slate-50 border-t border-slate-100">
            {{ $reviews->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
