<x-admin-layout>
    <x-slot name="header">Insurance Policies</x-slot>
    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search policy #..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            <select name="status" class="rounded-md border-gray-300 shadow-sm"><option value="all">All</option>
                @foreach(['ACTIVE','EXPIRED','CANCELLED','PENDING'] as $s)<option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }}>{{ ucfirst(strtolower($s)) }}</option>@endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Policy #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Company</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Premium</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($policies as $policy)
                        <tr>
                            <td class="px-6 py-4 text-sm font-mono text-indigo-600">{{ $policy->policy_number }}</td>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $policy->customer->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $policy->company->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ number_format($policy->premium ?? 0, 2) }} EGP</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $policy->start_date->format('M d') }} — {{ $policy->end_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $policy->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $policy->status }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No policies found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $policies->withQueryString()->links() }}</div>
        </div>
    </div>
</x-admin-layout>
