<x-admin-layout>
    <x-slot name="header">Audit Logs</x-slot>
    <div class="mb-6"><form method="GET" class="flex items-center space-x-2">
        <input type="text" name="search" placeholder="Search logs..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
        <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Search</button>
    </form></div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Time</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Target</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Changes</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">IP</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($logs as $log)
                        <tr>
                            <td class="px-6 py-4 text-xs text-gray-500">{{ $log->created_at->format('M d H:i') }}</td>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $log->user->name ?? 'System' }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full 
                                @if($log->action == 'created') bg-green-100 text-green-800 
                                @elseif($log->action == 'deleted') bg-red-100 text-red-800 
                                @else bg-blue-100 text-blue-800 @endif">{{ ucfirst($log->action) }}</span></td>
                            <td class="px-6 py-4 text-sm text-gray-500">
                                <span class="font-mono text-xs block">{{ class_basename($log->model_type) }}</span>
                                <span class="text-xs text-gray-400">#{{ Str::limit($log->model_id, 8) }}</span>
                            </td>
                            <td class="px-6 py-4 text-xs text-gray-500 font-mono">
                                @if($log->action == 'updated')
                                    @foreach($log->new_values ?? [] as $key => $val)
                                        @if($key !== 'updated_at')
                                            <div class="mb-1"><span class="font-bold text-gray-700">{{ $key }}:</span> {{ is_array($val) ? json_encode($val) : Str::limit($val, 20) }}</div>
                                        @endif
                                    @endforeach
                                @elseif($log->action == 'created')
                                    <span class="text-green-600">New Record</span>
                                @else
                                    <span class="text-red-600">Deleted</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-xs font-mono text-gray-400">{{ $log->ip_address }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No audit logs found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $logs->withQueryString()->links() }}</div>
        </div>
    </div>
</x-admin-layout>
