<x-app-layout>
    <x-slot name="header"><h2 class="text-xl font-semibold text-gray-800">سجلات الأمان</h2></x-slot>
    <div class="py-6"><div class="max-w-7xl mx-auto px-4">
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200 text-sm">
                <thead class="bg-gray-50"><tr>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">المستخدم</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">الحدث</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">IP</th>
                    <th class="px-4 py-3 text-right font-medium text-gray-500">التاريخ</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                @forelse($logs as $log)
                    <tr>
                        <td class="px-4 py-3">{{ $log->user->name ?? 'نظام' }}</td>
                        <td class="px-4 py-3"><span class="px-2 py-0.5 rounded text-xs {{ str_contains($log->event ?? '', 'fail') ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' }}">{{ $log->event ?? $log->action ?? '-' }}</span></td>
                        <td class="px-4 py-3 font-mono text-xs">{{ $log->ip_address ?? '-' }}</td>
                        <td class="px-4 py-3">{{ $log->created_at?->diffForHumans() ?? '-' }}</td>
                    </tr>
                @empty
                    <tr><td colspan="4" class="px-4 py-8 text-center text-gray-400">لا توجد سجلات أمان</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($logs, 'links'))<div class="mt-4">{{ $logs->links() }}</div>@endif
    </div></div>
</x-app-layout>
