<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الصيانة</h2>
            <p class="text-slate-500 text-sm">متابعة جداول الصيانة الدورية وسجلات الصيانة للمركبات</p>
        </div>
        <div>
            <a href="{{ route('admin.maintenance.create') }}" class="inline-flex items-center gap-2 px-6 py-2.5 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-md hover:shadow-lg font-bold">
                <x-icon name="Plus" class="h-5 w-5" />
                <span>تسجيل صيانة جديدة</span>
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Maintenance Schedules -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
             <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="CalendarDays" class="h-5 w-5 text-blue-500" />
                    جداول الصيانة القادمة
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-right">
                    <thead class="bg-slate-50 text-slate-600 font-bold border-b border-slate-100">
                        <tr>
                            <th class="px-6 py-4">العنوان</th>
                            <th class="px-6 py-4">المركبة</th>
                            <th class="px-6 py-4">الموعد القادم</th>
                            <th class="px-6 py-4">الحالة</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @forelse($schedules as $schedule)
                            <tr class="hover:bg-slate-50/50 transition-colors">
                                <td class="px-6 py-4 font-bold text-slate-800">{{ $schedule->title }}</td>
                                <td class="px-6 py-4 text-slate-600">{{ $schedule->vehicle->name ?? 'غير محدد' }}</td>
                                <td class="px-6 py-4 font-bold text-blue-600">{{ $schedule->next_service ? $schedule->next_service->format('Y-m-d') : '-' }}</td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold {{ $schedule->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                        {{ $schedule->is_active ? 'نشط' : 'غير نشط' }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                    <div class="flex flex-col items-center gap-2">
                                        <x-icon name="ClipboardDocumentCheck" class="h-10 w-10 text-slate-300" />
                                        <p>لا توجد جداول صيانة حالياً.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-t border-slate-100">
                {{ $schedules->withQueryString()->links() }}
            </div>
        </div>

        <!-- Recent Records -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-6 border-b border-slate-100 bg-slate-50/50">
                <h3 class="text-lg font-bold text-slate-800 flex items-center gap-2">
                    <x-icon name="WrenchScrewdriver" class="h-5 w-5 text-indigo-500" />
                    سجلات الصيانة الحديثة
                </h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    @forelse($records as $record)
                        <div class="p-4 bg-slate-50 rounded-xl border-r-4 {{ $record->status === 'COMPLETED' ? 'border-green-500' : 'border-yellow-500' }} hover:bg-slate-100 transition-colors">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h4 class="text-sm font-bold text-slate-900">{{ $record->title }}</h4>
                                    <p class="text-xs text-slate-500 mt-1">
                                        <span class="font-bold text-slate-700">{{ $record->vehicle->name ?? '' }}</span>
                                        <span class="mx-1">•</span>
                                        {{ $record->start_date->format('Y-m-d') }}
                                    </p>
                                </div>
                                <span class="text-sm font-bold text-emerald-600 bg-emerald-50 px-2 py-1 rounded-lg">
                                    {{ number_format($record->cost ?? 0, 2) }} ر.س
                                </span>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-slate-500">
                            <div class="flex flex-col items-center gap-2">
                                <x-icon name="ArchiveBox" class="h-10 w-10 text-slate-300" />
                                <p>لا توجد سجلات صيانة حديثة.</p>
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
