<x-admin-layout>
    <x-slot name="header">Marketing Campaigns</x-slot>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow p-6"><div class="text-sm font-medium text-gray-500">Total Campaigns</div><div class="text-2xl font-bold text-blue-600 mt-1">{{ $stats['total'] }}</div></div>
        <div class="bg-white rounded-lg shadow p-6"><div class="text-sm font-medium text-gray-500">Active</div><div class="text-2xl font-bold text-green-600 mt-1">{{ $stats['active'] }}</div></div>
        <div class="bg-white rounded-lg shadow p-6"><div class="text-sm font-medium text-gray-500">Total Budget</div><div class="text-2xl font-bold text-purple-600 mt-1">{{ number_format($stats['total_budget'], 2) }} EGP</div></div>
    </div>

    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search campaigns..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            <select name="status" class="rounded-md border-gray-300 shadow-sm"><option value="all">All Status</option>
                @foreach(['DRAFT','ACTIVE','PAUSED','COMPLETED'] as $s)<option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }}>{{ ucfirst(strtolower($s)) }}</option>@endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
        <button onclick="document.getElementById('addCampaignModal').classList.remove('hidden')" class="px-4 py-2 bg-purple-600 text-white rounded hover:bg-purple-700">+ New Campaign</button>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Campaign</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Budget</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($campaigns as $c)
                        <tr>
                            <td class="px-6 py-4"><div class="text-sm font-medium text-gray-900">{{ $c->name }}</div><div class="text-xs text-gray-500">{{ Str::limit($c->description, 40) }}</div></td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $c->type }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ number_format($c->budget ?? 0, 2) }} EGP</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $c->start_date?->format('M d') }} {{ $c->end_date ? '— '.$c->end_date->format('M d') : '' }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $c->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : ($c->status === 'PAUSED' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">{{ $c->status }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="px-6 py-4 text-center text-gray-500">No campaigns found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $campaigns->withQueryString()->links() }}</div>
        </div>
    </div>

    <div id="addCampaignModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-10 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium mb-4">New Campaign</h3>
            <form method="POST" action="{{ route('admin.marketing.store') }}" class="space-y-4">@csrf
                <div><label class="block text-sm font-medium text-gray-700">Name</label><input type="text" name="name" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700">Type</label><select name="type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="EMAIL">Email</option><option value="SMS">SMS</option><option value="SOCIAL">Social Media</option><option value="ADS">Ads</option></select></div>
                <div><label class="block text-sm font-medium text-gray-700">Status</label><select name="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="DRAFT">Draft</option><option value="ACTIVE">Active</option></select></div>
                <div class="grid grid-cols-2 gap-4">
                    <div><label class="block text-sm font-medium text-gray-700">Start</label><input type="date" name="start_date" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                    <div><label class="block text-sm font-medium text-gray-700">End</label><input type="date" name="end_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Budget</label><input type="number" step="0.01" name="budget" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div class="flex justify-end space-x-2"><button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">Cancel</button><button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded">Create</button></div>
            </form>
        </div>
    </div>
</x-admin-layout>
