<x-admin-layout>
    <x-slot name="header">Media Library</x-slot>
    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search files..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
            <select name="type" class="rounded-md border-gray-300 shadow-sm"><option value="all">All Types</option><option value="image" {{ request('type') == 'image' ? 'selected' : '' }}>Images</option><option value="video" {{ request('type') == 'video' ? 'selected' : '' }}>Videos</option><option value="application" {{ request('type') == 'application' ? 'selected' : '' }}>Documents</option></select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
        <form method="POST" action="{{ route('admin.media.store') }}" enctype="multipart/form-data" class="flex items-center space-x-2">
            @csrf
            <input type="file" name="file" required class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Upload</button>
        </form>
    </div>

    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
        @forelse($media as $item)
            <div class="bg-white rounded-lg shadow overflow-hidden">
                @if(str_starts_with($item->mime_type ?? '', 'image'))
                    <img src="{{ $item->url }}" alt="{{ $item->alt_text }}" class="w-full h-32 object-cover">
                @else
                    <div class="w-full h-32 bg-gray-100 flex flex-col items-center justify-center gap-2">
                        <span class="text-3xl">📄</span>
                        <a href="{{ $item->url }}" class="text-xs text-blue-600 hover:underline">Download</a>
                    </div>
                @endif
                <div class="p-2">
                    <div class="text-xs font-medium text-gray-900 truncate">{{ $item->original_name }}</div>
                    <div class="text-xs text-gray-500">{{ $item->size ? number_format($item->size / 1024) . ' KB' : '' }}</div>
                </div>
            </div>
        @empty
            <div class="col-span-full text-center text-gray-500 py-12">No media files found.</div>
        @endforelse
    </div>
    <div class="mt-6">{{ $media->withQueryString()->links() }}</div>
</x-admin-layout>
