<x-app-layout>
    <x-slot name="header"><h2 class="text-xl font-semibold text-gray-800">الإشعارات</h2></x-slot>
    <div class="py-6"><div class="max-w-4xl mx-auto px-4 space-y-3">
        @forelse($notifications as $n)
            <div class="bg-white rounded-lg shadow p-4 flex items-start gap-4 {{ $n->read_at ? 'opacity-60' : 'border-r-4 border-blue-500' }}">
                <div class="flex-shrink-0 mt-1">
                    <span class="w-3 h-3 rounded-full {{ $n->read_at ? 'bg-gray-300' : 'bg-blue-500' }} inline-block"></span>
                </div>
                <div class="flex-1">
                    <p class="text-sm font-medium text-gray-900">{{ $n->data['title'] ?? $n->type ?? 'إشعار' }}</p>
                    <p class="text-sm text-gray-500 mt-0.5">{{ $n->data['message'] ?? $n->data['body'] ?? '' }}</p>
                    <p class="text-xs text-gray-400 mt-1">{{ $n->created_at->diffForHumans() }}</p>
                </div>
                @unless($n->read_at)
                <form method="POST" action="{{ route('admin.notifications.read', $n->id) }}">
                    @csrf @method('PATCH')
                    <button class="text-xs text-blue-600 hover:underline">تعيين كمقروء</button>
                </form>
                @endunless
            </div>
        @empty
            <div class="bg-white rounded-lg shadow p-8 text-center text-gray-400">
                <svg class="w-12 h-12 mx-auto mb-3 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                <p>لا توجد إشعارات</p>
            </div>
        @endforelse
        @if(method_exists($notifications, 'links'))<div class="mt-4">{{ $notifications->links() }}</div>@endif
    </div></div>
</x-app-layout>
