<x-admin-layout>
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تفاصيل أمر الشراء: {{ $purchaseOrder->order_number }}</h2>
            <div class="flex items-center gap-2 mt-1">
                <span class="text-slate-500 text-sm">تاريخ الطلب: {{ $purchaseOrder->order_date->format('Y-m-d') }}</span>
                <span class="text-slate-300">|</span>
                <span class="px-2 py-0.5 rounded text-xs font-bold {{ $purchaseOrder->status == 'SENT' ? 'bg-blue-100 text-blue-700' : 'bg-gray-100 text-gray-700' }}">
                    {{ $purchaseOrder->status }}
                </span>
            </div>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('admin.purchase-orders.index') }}" class="px-4 py-2 border border-slate-200 rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">عودة</a>
            
            @if(!in_array($purchaseOrder->status, ['COMPLETED', 'CANCELLED']))
                <a href="{{ route('purchase-orders.receive', $purchaseOrder->id) }}" class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors flex items-center gap-2 font-bold shadow-sm">
                    <x-icon name="Cube" class="h-4 w-4" />
                    استلام منتجات
                </a>
            @endif

            <a href="{{ route('purchase-orders.bill.create', $purchaseOrder->id) }}" class="px-4 py-2 bg-yellow-600 text-white rounded-lg hover:bg-yellow-700 transition-colors flex items-center gap-2 font-bold shadow-sm">
                <x-icon name="CurrencyDollar" class="h-4 w-4" />
                إنشاء فاتورة
            </a>

            <button onclick="window.print()" class="px-4 py-2 bg-slate-800 text-white rounded-lg hover:bg-slate-700 transition-colors flex items-center gap-2">
                <x-icon name="Printer" class="h-4 w-4" />
                طباعة
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Items Table -->
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                <h3 class="font-bold text-slate-800 mb-4">المنتجات المطلوبة</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">المنتج</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الكمية</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">السعر</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">الإجمالي</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($purchaseOrder->items as $item)
                                <tr>
                                    <td class="px-4 py-3 text-sm text-slate-700">{{ $item->product->name ?? 'منتج غير معروف' }}</td>
                                    <td class="px-4 py-3 text-sm text-slate-700">{{ $item->quantity_ordered }}</td>
                                    <td class="px-4 py-3 text-sm text-slate-700">{{ number_format($item->unit_price, 2) }}</td>
                                    <td class="px-4 py-3 text-sm font-bold text-slate-900">{{ number_format($item->total_price, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="bg-slate-50">
                                <td colspan="3" class="px-4 py-3 text-right font-bold text-slate-700">الإجمالي الكلي</td>
                                <td class="px-4 py-3 font-bold text-blue-600 text-lg">{{ number_format($purchaseOrder->total_amount, 2) }} ج.م</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1 space-y-6">
            <!-- Supplier Info -->
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">بيانات المورد</h3>
                <div class="space-y-3">
                    <div>
                        <span class="block text-xs text-slate-500">الاسم</span>
                        <span class="font-medium text-slate-900">{{ $purchaseOrder->supplier->name }}</span>
                    </div>
                    <div>
                        <span class="block text-xs text-slate-500">الشخص المسؤول</span>
                        <span class="text-sm text-slate-700">{{ $purchaseOrder->supplier->contact_person ?? '-' }}</span>
                    </div>
                    <div>
                        <span class="block text-xs text-slate-500">الهاتف</span>
                        <span class="text-sm text-slate-700">{{ $purchaseOrder->supplier->phone ?? '-' }}</span>
                    </div>
                    <div>
                        <span class="block text-xs text-slate-500">البريد الإلكتروني</span>
                        <span class="text-sm text-slate-700">{{ $purchaseOrder->supplier->email ?? '-' }}</span>
                    </div>
                </div>
            </div>

            <!-- Meta Info -->
            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
                <h3 class="font-bold text-slate-800 mb-4 border-b pb-2">معلومات إضافية</h3>
                <div class="space-y-3">
                    <div>
                        <span class="block text-xs text-slate-500">تاريخ الاستلام المتوقع</span>
                        <span class="text-sm text-slate-700">{{ $purchaseOrder->expected_delivery_date ? $purchaseOrder->expected_delivery_date->format('Y-m-d') : '-' }}</span>
                    </div>
                    <div>
                        <span class="block text-xs text-slate-500">تم الإنشاء بواسطة</span>
                        <span class="text-sm text-slate-700">{{ $purchaseOrder->creator->name ?? 'System' }}</span>
                    </div>
                    @if($purchaseOrder->notes)
                        <div>
                            <span class="block text-xs text-slate-500">ملاحظات</span>
                            <div class="text-sm text-slate-600 bg-yellow-50 p-2 rounded border border-yellow-100 mt-1">
                                {{ $purchaseOrder->notes }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
