<x-admin-layout>
    <div class="p-6">
        <h2 class="text-2xl font-bold text-white mb-6">إنشاء عرض سعر جديد</h2>

        @if($errors->any())
            <div class="bg-red-500/20 text-red-400 p-4 rounded-lg mb-4">
                <ul>@foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
            </div>
        @endif

        <form action="{{ route('admin.quotations.store') }}" method="POST" class="space-y-6">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-gray-300 mb-1">العميل</label>
                    <select name="customer_id" required class="w-full bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                        <option value="">اختر العميل</option>
                        @foreach($customers as $c)
                            <option value="{{ $c->id }}">{{ $c->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-gray-300 mb-1">السيارة (اختياري)</label>
                    <select name="vehicle_id" class="w-full bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                        <option value="">بدون سيارة</option>
                        @foreach($vehicles as $v)
                            <option value="{{ $v->id }}">{{ $v->make }} {{ $v->model }} {{ $v->year }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-gray-300 mb-1">صالح حتى</label>
                    <input type="date" name="valid_until" required class="w-full bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                </div>
            </div>

            <div>
                <label class="block text-gray-300 mb-1">ملاحظات</label>
                <textarea name="notes" rows="2" class="w-full bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5"></textarea>
            </div>

            <div id="items-container">
                <h3 class="text-lg font-semibold text-white mb-2">البنود</h3>
                <div class="item-row grid grid-cols-4 gap-3 mb-2">
                    <input type="text" name="items[0][description]" placeholder="الوصف" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                    <input type="number" name="items[0][quantity]" placeholder="الكمية" min="1" value="1" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                    <input type="number" name="items[0][unit_price]" placeholder="سعر الوحدة" step="0.01" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
                    <button type="button" onclick="this.closest('.item-row').remove()" class="bg-red-500/20 text-red-400 rounded-lg hover:bg-red-500/30">حذف</button>
                </div>
            </div>

            <button type="button" onclick="addItem()" class="text-amber-400 hover:text-amber-300">+ إضافة بند</button>

            <div class="flex gap-3">
                <button type="submit" class="bg-amber-500 hover:bg-amber-600 text-black font-semibold py-2.5 px-6 rounded-lg transition">حفظ عرض السعر</button>
                <a href="{{ route('admin.quotations.index') }}" class="bg-gray-600 hover:bg-gray-500 text-white py-2.5 px-6 rounded-lg transition">إلغاء</a>
            </div>
        </form>
    </div>

    <script>
    let itemIndex = 1;
    function addItem() {
        const container = document.getElementById('items-container');
        const html = `<div class="item-row grid grid-cols-4 gap-3 mb-2">
            <input type="text" name="items[${itemIndex}][description]" placeholder="الوصف" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
            <input type="number" name="items[${itemIndex}][quantity]" placeholder="الكمية" min="1" value="1" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
            <input type="number" name="items[${itemIndex}][unit_price]" placeholder="سعر الوحدة" step="0.01" required class="bg-gray-700 border border-gray-600 text-white rounded-lg p-2.5">
            <button type="button" onclick="this.closest('.item-row').remove()" class="bg-red-500/20 text-red-400 rounded-lg hover:bg-red-500/30">حذف</button>
        </div>`;
        container.insertAdjacentHTML('beforeend', html);
        itemIndex++;
    }
    </script>
</x-admin-layout>
