<x-admin-layout>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-white">عروض الأسعار</h2>
            <a href="{{ route('admin.quotations.create') }}"
               class="bg-amber-500 hover:bg-amber-600 text-black font-semibold py-2 px-4 rounded-lg transition">
                + عرض سعر جديد
            </a>
        </div>

        @if(session('success'))
            <div class="bg-green-500/20 text-green-400 p-4 rounded-lg mb-4">{{ session('success') }}</div>
        @endif

        <div class="bg-gray-800 rounded-xl overflow-hidden">
            <table class="w-full text-right">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="p-4 text-gray-300">رقم العرض</th>
                        <th class="p-4 text-gray-300">العميل</th>
                        <th class="p-4 text-gray-300">المبلغ</th>
                        <th class="p-4 text-gray-300">الحالة</th>
                        <th class="p-4 text-gray-300">صالح حتى</th>
                        <th class="p-4 text-gray-300">إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($quotations as $q)
                        <tr class="border-t border-gray-700 hover:bg-gray-750">
                            <td class="p-4 text-white font-mono">{{ $q->quotation_number }}</td>
                            <td class="p-4 text-gray-300">{{ $q->customer?->name ?? '-' }}</td>
                            <td class="p-4 text-amber-400 font-bold">{{ number_format($q->total_amount, 2) }} ج.م</td>
                            <td class="p-4">
                                <span class="px-3 py-1 rounded-full text-xs font-semibold
                                    {{ $q->status === 'DRAFT' ? 'bg-gray-600 text-gray-300' : '' }}
                                    {{ $q->status === 'SENT' ? 'bg-blue-500/20 text-blue-400' : '' }}
                                    {{ $q->status === 'ACCEPTED' ? 'bg-green-500/20 text-green-400' : '' }}
                                    {{ $q->status === 'CONVERTED' ? 'bg-amber-500/20 text-amber-400' : '' }}
                                    {{ $q->status === 'EXPIRED' ? 'bg-red-500/20 text-red-400' : '' }}">
                                    {{ $q->status }}
                                </span>
                            </td>
                            <td class="p-4 text-gray-400">{{ $q->valid_until?->format('Y-m-d') }}</td>
                            <td class="p-4 flex gap-2">
                                <a href="{{ route('admin.quotations.show', $q) }}" class="text-blue-400 hover:text-blue-300">عرض</a>
                                @if($q->status !== 'CONVERTED')
                                    <form action="{{ route('admin.quotations.convert', $q) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" class="text-green-400 hover:text-green-300" onclick="return confirm('تحويل لفاتورة؟')">تحويل لفاتورة</button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="p-8 text-center text-gray-500">لا توجد عروض أسعار</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">{{ $quotations->links() }}</div>
    </div>
</x-admin-layout>
