<x-admin-layout>
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-white">عرض سعر: {{ $quotation->quotation_number }}</h2>
            <div class="flex gap-2">
                @if($quotation->status !== 'CONVERTED')
                    <form action="{{ route('admin.quotations.convert', $quotation) }}" method="POST">
                        @csrf
                        <button type="submit" class="bg-green-500 hover:bg-green-600 text-white py-2 px-4 rounded-lg" onclick="return confirm('تحويل لفاتورة؟')">
                            تحويل لفاتورة
                        </button>
                    </form>
                @endif
                <a href="{{ route('admin.quotations.index') }}" class="bg-gray-600 hover:bg-gray-500 text-white py-2 px-4 rounded-lg">رجوع</a>
            </div>
        </div>

        @if(session('success'))
            <div class="bg-green-500/20 text-green-400 p-4 rounded-lg mb-4">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="bg-red-500/20 text-red-400 p-4 rounded-lg mb-4">{{ session('error') }}</div>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="bg-gray-800 p-5 rounded-xl">
                <h3 class="text-lg font-semibold text-white mb-3">معلومات العرض</h3>
                <dl class="space-y-2 text-gray-300">
                    <div class="flex justify-between"><dt>الحالة:</dt><dd class="font-semibold">{{ $quotation->status }}</dd></div>
                    <div class="flex justify-between"><dt>صالح حتى:</dt><dd>{{ $quotation->valid_until?->format('Y-m-d') }}</dd></div>
                    <div class="flex justify-between"><dt>تاريخ الإنشاء:</dt><dd>{{ $quotation->created_at->format('Y-m-d') }}</dd></div>
                </dl>
            </div>
            <div class="bg-gray-800 p-5 rounded-xl">
                <h3 class="text-lg font-semibold text-white mb-3">معلومات العميل</h3>
                <dl class="space-y-2 text-gray-300">
                    <div class="flex justify-between"><dt>الاسم:</dt><dd>{{ $quotation->customer?->name }}</dd></div>
                    <div class="flex justify-between"><dt>البريد:</dt><dd>{{ $quotation->customer?->email }}</dd></div>
                    @if($quotation->vehicle)
                        <div class="flex justify-between"><dt>السيارة:</dt><dd>{{ $quotation->vehicle->make }} {{ $quotation->vehicle->model }}</dd></div>
                    @endif
                </dl>
            </div>
        </div>

        <div class="bg-gray-800 rounded-xl overflow-hidden">
            <table class="w-full text-right">
                <thead class="bg-gray-700">
                    <tr>
                        <th class="p-4 text-gray-300">الوصف</th>
                        <th class="p-4 text-gray-300">الكمية</th>
                        <th class="p-4 text-gray-300">سعر الوحدة</th>
                        <th class="p-4 text-gray-300">الإجمالي</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($quotation->items as $item)
                        <tr class="border-t border-gray-700">
                            <td class="p-4 text-white">{{ $item->description }}</td>
                            <td class="p-4 text-gray-300">{{ $item->quantity }}</td>
                            <td class="p-4 text-gray-300">{{ number_format($item->unit_price, 2) }}</td>
                            <td class="p-4 text-amber-400 font-bold">{{ number_format($item->total, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-750">
                    <tr class="border-t border-gray-600">
                        <td colspan="3" class="p-4 text-gray-300 text-left font-semibold">المجموع الفرعي</td>
                        <td class="p-4 text-white font-bold">{{ number_format($quotation->subtotal, 2) }} ج.م</td>
                    </tr>
                    <tr>
                        <td colspan="3" class="p-4 text-gray-300 text-left font-semibold">الضريبة (14%)</td>
                        <td class="p-4 text-white">{{ number_format($quotation->tax_amount, 2) }} ج.م</td>
                    </tr>
                    <tr class="border-t border-gray-600">
                        <td colspan="3" class="p-4 text-white text-left font-bold text-lg">الإجمالي</td>
                        <td class="p-4 text-amber-400 font-bold text-lg">{{ number_format($quotation->total_amount, 2) }} ج.م</td>
                    </tr>
                </tfoot>
            </table>
        </div>

        @if($quotation->notes)
            <div class="bg-gray-800 p-5 rounded-xl mt-4">
                <h3 class="text-lg font-semibold text-white mb-2">ملاحظات</h3>
                <p class="text-gray-300">{{ $quotation->notes }}</p>
            </div>
        @endif
    </div>
</x-admin-layout>
