<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تعديل الدور: {{ $role->name }}</h2>
            <p class="text-slate-500 text-sm">تحديث صلاحيات وتفاصيل الدور</p>
        </div>
        <a href="{{ route('admin.roles.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-600 hover:bg-slate-50 hover:text-slate-800 transition-colors">
            <x-icon name="ArrowRight" class="h-4 w-4" />
            <span>إلغاء وعودة</span>
        </a>
    </div>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-8">
                <form method="POST" action="{{ route('admin.roles.update', $role) }}" class="space-y-6">
                    @csrf
                    @method('PUT')
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Role Name -->
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">اسم الدور</label>
                            <input type="text" name="name" required 
                                   class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                   value="{{ old('name', $role->name) }}" placeholder="مثال: مدير المبيعات">
                             @error('name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>

                        <!-- Role Type -->
                        <div>
                            <label class="block text-sm font-medium text-slate-700 mb-1">نوع الدور (الأساس)</label>
                            <select name="role" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                                @foreach(['ADMIN' => 'مدير', 'EMPLOYEE' => 'موظف', 'SALES_MANAGER' => 'مدير مبيعات', 'ACCOUNTANT' => 'محاسب', 'CUSTOMER' => 'عميل'] as $val => $label)
                                    <option value="{{ $val }}" {{ $role->role === $val ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Description -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1">الوصف</label>
                        <textarea name="description" rows="3" 
                                  class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                  placeholder="وصف موجز لهذا الدور...">{{ old('description', $role->description) }}</textarea>
                    </div>

                    <!-- Permissions -->
                    <div class="border-t border-gray-100 pt-6">
                        <h3 class="text-lg font-bold text-slate-800 mb-4 flex items-center gap-2">
                            <x-icon name="Shield" class="h-5 w-5 text-slate-400" />
                            تحديد الصلاحيات
                        </h3>
                        
                        @php $rolePerms = is_array($role->permissions) ? $role->permissions : []; @endphp
                        
                        <div class="bg-slate-50 rounded-xl p-4 border border-slate-200 max-h-96 overflow-y-auto">
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                                @foreach($permissions as $perm)
                                    <label class="flex items-start gap-3 p-3 bg-white rounded-lg border border-slate-100 hover:border-blue-200 hover:shadow-sm transition-all cursor-pointer group">
                                        <input type="checkbox" name="permissions[]" value="{{ $perm->name }}" 
                                               {{ in_array($perm->name, $rolePerms) ? 'checked' : '' }}
                                               class="rounded border-gray-300 text-blue-600 focus:ring-blue-500 mt-1">
                                        <div class="text-sm">
                                            <span class="font-medium text-slate-700 group-hover:text-blue-700 block">{{ $perm->description ?? $perm->name }}</span>
                                            <span class="text-xs text-slate-400 font-mono">{{ $perm->name }}</span>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <div class="pt-6 border-t border-gray-100 flex items-center justify-end gap-3">
                        <button type="submit" class="inline-flex items-center gap-2 px-6 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
                            <x-icon name="Check" class="h-4 w-4" />
                            <span>حفظ التعديلات</span>
                        </button>
                    </div>
                </form>
            </div>
            
             @unless($role->is_system)
                <div class="bg-red-50/50 p-6 border-t border-red-100 flex items-center justify-between">
                    <div>
                        <h4 class="text-sm font-bold text-red-800">منطقة الخطر</h4>
                        <p class="text-xs text-red-600 mt-1">حذف هذا الدور سيؤدي إزالة كافة الصلاحيات المرتبطة به من المستخدمين.</p>
                    </div>
                    <form method="POST" action="{{ route('admin.roles.destroy', $role) }}" onsubmit="return confirm('هل أنت متأكد من حذف هذا الدور؟ هذا الإجراء لا يمكن التراجع عنه.')">
                        @csrf @method('DELETE')
                        <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-red-200 text-red-600 rounded-xl hover:bg-red-50 transition-colors text-sm font-medium shadow-sm">
                            <x-icon name="Trash" class="h-4 w-4" />
                            <span>حذف الدور</span>
                        </button>
                    </form>
                </div>
            @endunless
        </div>
    </div>
</x-admin-layout>
