<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">الأدوار والصلاحيات</h2>
            <p class="text-slate-500 text-sm">إدارة مصفوفة الصلاحيات وأدوار المستخدمين</p>
        </div>
        <a href="{{ route('admin.roles.create') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
            <x-icon name="Plus" class="h-4 w-4" />
            <span>إضافة دور جديد</span>
        </a>
    </div>

    <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الاسم</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الوصف</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الدور الأساسي</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">عدد الصلاحيات</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($templates as $t)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold text-slate-900">{{ $t->name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-xs text-slate-500 max-w-xs truncate" title="{{ $t->description }}">{{ $t->description ?? '-' }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full bg-blue-50 text-blue-700 border border-blue-100">
                                    {{ $t->role }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600 font-mono">
                                {{ is_array($t->permissions) ? count($t->permissions) : 0 }} صلاحية
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium flex items-center justify-end gap-2">
                                @unless($t->is_system)
                                    <a href="{{ route('admin.roles.edit', $t) }}" class="p-2 bg-slate-100 text-slate-600 rounded-lg hover:bg-slate-200 transition-colors" title="تعديل">
                                        <x-icon name="Edit" class="h-4 w-4" />
                                    </a>
                                     <form action="{{ route('admin.roles.destroy', $t->id) }}" method="POST" class="inline-block" onsubmit="return confirm('هل أنت متأكد من حذف هذا الدور؟');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                            <x-icon name="Trash" class="h-4 w-4" />
                                        </button>
                                    </form>
                                @else
                                    <span class="text-xs text-slate-400 italic">نظام (لا يمكن التعديل)</span>
                                @endunless
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="Shield" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا توجد أدوار</p>
                                    <p class="text-sm">لم يتم العثور على أي أدوار معرفة في النظام.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</x-admin-layout>
