<x-admin-layout>
    <x-slot name="header">Sales Overview</x-slot>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium mb-4">Sales Funnels</h3>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50"><tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Stage</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Value</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr></thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($funnels as $funnel)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $funnel->name }}</td>
                                <td class="px-4 py-3 text-sm text-gray-500">{{ $funnel->stage }}</td>
                                <td class="px-4 py-3 text-sm font-medium">{{ number_format($funnel->value ?? 0, 2) }}</td>
                                <td class="px-4 py-3"><span class="px-2 text-xs rounded-full {{ $funnel->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $funnel->status ?? 'N/A' }}</span></td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-3 text-center text-gray-500">No funnels.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">{{ $funnels->withQueryString()->links() }}</div>
            </div>
        </div>
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium mb-4">Sales Targets</h3>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50"><tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Assigned To</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Target</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Achieved</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">%</th>
                    </tr></thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($targets as $target)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $target->assignee->name ?? 'N/A' }}</td>
                                <td class="px-4 py-3 text-sm font-medium">{{ number_format($target->target_amount ?? 0, 2) }}</td>
                                <td class="px-4 py-3 text-sm text-green-600">{{ number_format($target->achieved_amount ?? 0, 2) }}</td>
                                <td class="px-4 py-3 text-sm">
                                    @php $pct = $target->target_amount > 0 ? min(100, ($target->achieved_amount / $target->target_amount) * 100) : 0; @endphp
                                    <div class="flex items-center"><div class="w-16 bg-gray-200 rounded-full h-2 mr-2"><div class="bg-blue-600 h-2 rounded-full" style="width: {{ $pct }}%"></div></div><span class="text-xs">{{ number_format($pct) }}%</span></div>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-3 text-center text-gray-500">No targets set.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">{{ $targets->withQueryString()->links() }}</div>
            </div>
        </div>
    </div>
</x-admin-layout>
