<x-admin-layout>
    <div class="p-6">
        <h2 class="text-2xl font-bold text-white mb-6">نتائج البحث: "{{ $query }}"</h2>

        @if($results->isEmpty())
            <div class="bg-gray-800 rounded-xl p-8 text-center text-gray-500">
                <p class="text-lg">لا توجد نتائج للبحث عن "{{ $query }}"</p>
            </div>
        @else
            <div class="space-y-3">
                @foreach($results as $result)
                    <a href="{{ $result['url'] }}" class="block bg-gray-800 hover:bg-gray-750 p-4 rounded-xl transition">
                        <div class="flex items-center gap-4">
                            <span class="px-3 py-1 rounded-full text-xs font-semibold bg-amber-500/20 text-amber-400">
                                {{ $result['type'] }}
                            </span>
                            <div>
                                <h3 class="text-white font-semibold">{{ $result['title'] }}</h3>
                                <p class="text-gray-400 text-sm">{{ $result['subtitle'] }}</p>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        @endif
    </div>
</x-admin-layout>
