<x-admin-layout>
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-slate-800">إضافة مورد جديد</h2>
        <p class="text-slate-500 text-sm">أدخل بيانات المورد الجديد</p>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-slate-100 p-6">
        <form action="{{ route('admin.suppliers.store') }}" method="POST">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Name -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">اسم المورد <span class="text-red-500">*</span></label>
                    <input type="text" name="name" value="{{ old('name') }}" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                    @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </div>

                <!-- Contact Person -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">الشخص المسؤول</label>
                    <input type="text" name="contact_person" value="{{ old('contact_person') }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Email -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">البريد الإلكتروني</label>
                    <input type="email" name="email" value="{{ old('email') }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Phone -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">رقم الهاتف</label>
                    <input type="text" name="phone" value="{{ old('phone') }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Tax Number -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">الرقم الضريبي</label>
                    <input type="text" name="tax_number" value="{{ old('tax_number') }}" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Payment Terms -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2">شروط الدفع</label>
                    <input type="text" name="payment_terms" value="{{ old('payment_terms') }}" placeholder="مثال: Net 30, نقداً" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                </div>

                <!-- Address -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-slate-700 mb-2">العنوان</label>
                    <textarea name="address" rows="3" class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">{{ old('address') }}</textarea>
                </div>

                <!-- Is Active -->
                <div class="md:col-span-2">
                    <label class="inline-flex items-center gap-2 cursor-pointer">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', 1) ? 'checked' : '' }} class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                        <span class="text-sm font-medium text-slate-700">المورد نشط</span>
                    </label>
                </div>
            </div>

            <div class="flex justify-end gap-4 border-t border-gray-100 pt-6">
                <a href="{{ route('admin.suppliers.index') }}" class="px-6 py-2.5 rounded-xl border border-gray-200 text-gray-700 font-semibold hover:bg-gray-50 transition-colors">إلغاء</a>
                <button type="submit" class="px-6 py-2.5 rounded-xl bg-blue-600 text-white font-semibold hover:bg-blue-700 transition-colors shadow-sm">حفظ</button>
            </div>
        </form>
    </div>
</x-admin-layout>
