<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">إدارة الموردين</h2>
            <p class="text-slate-500 text-sm">إدارة قائمة الموردين وبيانات الاتصال بهم</p>
        </div>
        <a href="{{ route('admin.suppliers.create') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
            <x-icon name="Plus" class="h-4 w-4" />
            <span>إضافة مورد جديد</span>
        </a>
    </div>

    <div class="mb-6 rounded-2xl bg-white p-4 shadow-sm border border-slate-100">
        <form method="GET" action="{{ route('admin.suppliers.index') }}" class="flex flex-col md:flex-row items-center gap-4">
            <div class="relative flex-1 w-full">
                <x-icon name="Search" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" />
                <input type="text" name="search" placeholder="ابحث باسم المورد، الشخص المسؤول، أو الهاتف..." value="{{ request('search') }}" class="w-full rounded-xl border-gray-200 pr-10 focus:border-blue-500 focus:ring-blue-500">
            </div>
            <button type="submit" class="w-full md:w-auto inline-flex items-center justify-center rounded-xl bg-slate-800 px-6 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-slate-700 transition-all">
                <x-icon name="Filter" class="ml-2 h-4 w-4" />
                تصفية
            </button>
        </form>
    </div>

    <div class="overflow-hidden rounded-2xl bg-white shadow-sm border border-slate-100">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">المورد</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">جهة الاتصال</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">بيانات التواصل</th>
                        <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">الحالة</th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($suppliers as $supplier)
                        <tr class="hover:bg-slate-50/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-3">
                                    <div class="h-10 w-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 font-bold">
                                        {{ substr($supplier->name, 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-slate-900">{{ $supplier->name }}</div>
                                        <div class="text-xs text-slate-500">{{ $supplier->tax_number ?? 'رقم ضريبي غير مسجل' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-700">
                                {{ $supplier->contact_person ?? '-' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex flex-col text-xs">
                                    <span class="text-slate-700 mb-1 flex items-center gap-1">
                                        <x-icon name="Phone" class="h-3 w-3 text-slate-400" /> {{ $supplier->phone ?? '-' }}
                                    </span>
                                    <span class="text-slate-500 flex items-center gap-1">
                                        <x-icon name="Mail" class="h-3 w-3 text-slate-400" /> {{ $supplier->email ?? '-' }}
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full {{ $supplier->is_active ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                                    {{ $supplier->is_active ? 'نشط' : 'غير نشط' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium flex items-center justify-end gap-2">
                                <a href="{{ route('admin.suppliers.edit', $supplier->id) }}" class="p-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition-colors" title="تعديل">
                                    <x-icon name="Edit" class="h-4 w-4" />
                                </a>
                                <form action="{{ route('admin.suppliers.destroy', $supplier->id) }}" method="POST" class="inline-block" onsubmit="return confirm('هل أنت متأكد من حذف هذا المورد؟');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" title="حذف">
                                        <x-icon name="Trash" class="h-4 w-4" />
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="h-16 w-16 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                        <x-icon name="Inbox" class="h-8 w-8 text-slate-300" />
                                    </div>
                                    <p class="text-lg font-medium">لا يوجد موردين</p>
                                    <p class="text-sm">لم يتم العثور على أي موردين. قم بإضافة أول مورد.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="border-t border-gray-100 bg-gray-50/50 p-4">
            {{ $suppliers->withQueryString()->links() }}
        </div>
    </div>
</x-admin-layout>
