<x-admin-layout>
    <x-slot name="header">
        Complaints
    </x-slot>

    <div class="mb-6 flex justify-between items-center">
        <form method="GET" action="{{ route('admin.support.complaints.index') }}" class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search complaint # or subject..." value="{{ request('search') }}" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
             <select name="status" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                <option value="all">All Status</option>
                <option value="NEW" {{ request('status') == 'NEW' ? 'selected' : '' }}>New</option>
                <option value="INVESTIGATING" {{ request('status') == 'INVESTIGATING' ? 'selected' : '' }}>Investigating</option>
                <option value="RESOLVED" {{ request('status') == 'RESOLVED' ? 'selected' : '' }}>Resolved</option>
                <option value="DISMISSED" {{ request('status') == 'DISMISSED' ? 'selected' : '' }}>Dismissed</option>
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Complaint #</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Subject</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Priority</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($complaints as $complaint)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-indigo-600">
                                <a href="{{ route('admin.support.complaints.show', $complaint->id) }}">{{ $complaint->complaint_number }}</a>
                            </td>
                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ Str::limit($complaint->subject, 30) }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $complaint->customer->name ?? 'N/A' }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    {{ $complaint->status === 'NEW' ? 'bg-red-100 text-red-800' : 
                                       ($complaint->status === 'RESOLVED' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800') }}">
                                    {{ str_replace('_', ' ', $complaint->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    {{ $complaint->priority === 'CRITICAL' ? 'bg-red-100 text-red-800' : 
                                       ($complaint->priority === 'HIGH' ? 'bg-orange-100 text-orange-800' : 'bg-green-100 text-green-800') }}">
                                    {{ $complaint->priority }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.support.complaints.show', $complaint->id) }}" class="text-indigo-600 hover:text-indigo-900">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-4 text-center text-gray-500">No complaints found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">
                {{ $complaints->withQueryString()->links() }}
            </div>
        </div>
    </div>
</x-admin-layout>
