<x-admin-layout>
    <x-slot name="header">
        Complaint #{{ $complaint->complaint_number }}
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900">{{ $complaint->subject }}</h3>
                    <p class="mt-1 max-w-2xl text-sm text-gray-500">Filed on {{ $complaint->created_at->format('M d, Y H:i') }} by {{ $complaint->customer->name }}</p>
                </div>
                 <div class="flex space-x-2">
                     <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $complaint->priority === 'CRITICAL' ? 'bg-red-100 text-red-800' : 
                           ($complaint->priority === 'HIGH' ? 'bg-orange-100 text-orange-800' : 'bg-green-100 text-green-800') }}">
                        {{ $complaint->priority }}
                    </span>
                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $complaint->status === 'NEW' ? 'bg-red-100 text-red-800' : 
                           ($complaint->status === 'RESOLVED' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800') }}">
                        {{ str_replace('_', ' ', $complaint->status) }}
                    </span>
                </div>
            </div>
            <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                <div class="prose max-w-none text-gray-900">
                    {{ $complaint->description }}
                </div>
            </div>
             <div class="bg-gray-50 px-4 py-4 sm:px-6">
                <div class="text-sm text-gray-500">
                    Assigned to: <span class="font-medium text-gray-900">{{ $complaint->assignedTo->name ?? 'Unassigned' }}</span> | Branch: <span class="font-medium text-gray-900">{{ $complaint->branch->name ?? 'All' }}</span>
                </div>
            </div>
        </div>

        <!-- Follow-up Actions -->
        <h4 class="text-lg font-medium text-gray-900 mb-4">Follow-up History</h4>
        <div class="space-y-4 mb-6">
            @forelse($complaint->followUps as $followUp)
                <div class="bg-white shadow sm:rounded-lg p-4 border-l-4 border-blue-400">
                    <div class="flex justify-between items-center mb-2">
                        <div class="flex items-center">
                            <span class="font-medium text-gray-900 mr-2">{{ $followUp->author->name }}</span>
                            <span class="text-sm text-gray-500">{{ $followUp->created_at->format('M d, Y H:i') }}</span>
                        </div>
                    </div>
                    <div class="text-gray-700 mb-2">
                        {{ $followUp->content }}
                    </div>
                    @if($followUp->action)
                        <div class="text-sm text-gray-600 bg-gray-100 p-2 rounded">
                            <strong>Action:</strong> {{ $followUp->action }}
                        </div>
                    @endif
                    @if($followUp->next_follow_up)
                        <div class="mt-2 text-xs text-blue-600">
                            Next Follow-up: {{ $followUp->next_follow_up->format('M d, Y') }}
                        </div>
                    @endif
                </div>
            @empty
                <p class="text-gray-500 text-center py-4">No follow-ups recorded.</p>
            @endforelse
        </div>

        <!-- Add Follow-up -->
        <div class="bg-white shadow sm:rounded-lg p-6">
            <h4 class="text-lg font-medium text-gray-900 mb-4">Record Filter-up / Action</h4>
            <form action="{{ route('admin.support.complaints.followUp', $complaint->id) }}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div class="col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Content / Result</label>
                        <textarea name="content" rows="3" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"></textarea>
                    </div>
                     <div>
                        <label class="block text-sm font-medium text-gray-700">Action Taken</label>
                        <input type="text" name="action" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                     <div>
                        <label class="block text-sm font-medium text-gray-700">Next Follow-up Date</label>
                        <input type="date" name="next_follow_up" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Record Action</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>
