<x-admin-layout>
    <x-slot name="header">
        Ticket #{{ $ticket->ticket_number }}
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900">{{ $ticket->subject }}</h3>
                    <p class="mt-1 max-w-2xl text-sm text-gray-500">Created on {{ $ticket->created_at->format('M d, Y H:i') }} by {{ $ticket->customer->name }}</p>
                </div>
                <div class="flex space-x-2">
                     <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $ticket->priority === 'URGENT' ? 'bg-red-100 text-red-800' : 
                           ($ticket->priority === 'HIGH' ? 'bg-orange-100 text-orange-800' : 'bg-green-100 text-green-800') }}">
                        {{ $ticket->priority }}
                    </span>
                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $ticket->status === 'OPEN' ? 'bg-blue-100 text-blue-800' : 
                           ($ticket->status === 'RESOLVED' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800') }}">
                        {{ str_replace('_', ' ', $ticket->status) }}
                    </span>
                </div>
            </div>
            <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                <div class="prose max-w-none text-gray-900">
                    {{ $ticket->description }}
                </div>
            </div>
             <div class="bg-gray-50 px-4 py-4 sm:px-6 flex justify-between items-center">
                <div class="text-sm text-gray-500">
                    Assigned to: <span class="font-medium text-gray-900">{{ $ticket->assignedTo->name ?? 'Unassigned' }}</span>
                </div>
                <form action="{{ route('admin.support.tickets.updateStatus', $ticket->id) }}" method="POST" class="flex items-center space-x-2">
                    @csrf
                    @method('PATCH')
                    <select name="status" class="rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 text-sm">
                        <option value="OPEN" {{ $ticket->status == 'OPEN' ? 'selected' : '' }}>Open</option>
                        <option value="IN_PROGRESS" {{ $ticket->status == 'IN_PROGRESS' ? 'selected' : '' }}>In Progress</option>
                        <option value="RESOLVED" {{ $ticket->status == 'RESOLVED' ? 'selected' : '' }}>Resolved</option>
                        <option value="CLOSED" {{ $ticket->status == 'CLOSED' ? 'selected' : '' }}>Closed</option>
                    </select>
                    <button type="submit" class="px-3 py-1 bg-indigo-600 text-white rounded text-sm hover:bg-indigo-700">Update Status</button>
                </form>
            </div>
        </div>

        <!-- Comments -->
        <h4 class="text-lg font-medium text-gray-900 mb-4">Discussion</h4>
        <div class="space-y-4 mb-6">
            @forelse($ticket->comments as $comment)
                <div class="bg-white shadow sm:rounded-lg p-4 {{ $comment->is_internal ? 'border-l-4 border-yellow-400 bg-yellow-50' : '' }}">
                    <div class="flex justify-between items-center mb-2">
                        <div class="flex items-center">
                            <span class="font-medium text-gray-900 mr-2">{{ $comment->author->name }}</span>
                            @if($comment->is_internal)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">Internal Note</span>
                            @endif
                        </div>
                        <span class="text-sm text-gray-500">{{ $comment->created_at->format('M d, Y H:i') }}</span>
                    </div>
                    <div class="text-gray-700">
                        {{ $comment->content }}
                    </div>
                </div>
            @empty
                <p class="text-gray-500 text-center py-4">No comments yet.</p>
            @endforelse
        </div>

        <!-- Add Comment -->
        <div class="bg-white shadow sm:rounded-lg p-6">
            <h4 class="text-lg font-medium text-gray-900 mb-4">Reply</h4>
            <form action="{{ route('admin.support.tickets.storeComment', $ticket->id) }}" method="POST">
                @csrf
                <div class="mb-4">
                    <textarea name="content" rows="4" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" placeholder="Type your reply here..."></textarea>
                </div>
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input type="checkbox" name="is_internal" id="is_internal" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <label for="is_internal" class="ml-2 block text-sm text-gray-900">Internal Note (Visible only to staff)</label>
                    </div>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Send Reply</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>
