<x-admin-layout>
    <x-slot name="header">Tasks</x-slot>
    <div class="mb-6 flex justify-between items-center flex-wrap gap-4">
        <form method="GET" class="flex items-center space-x-2">
            <select name="status" class="rounded-md border-gray-300 shadow-sm"><option value="all">All Status</option>
                @foreach(['PENDING','IN_PROGRESS','COMPLETED','CANCELLED'] as $s)<option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }}>{{ ucfirst(strtolower(str_replace('_',' ',$s))) }}</option>@endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded hover:bg-gray-700">Filter</button>
        </form>
        <button onclick="document.getElementById('addTaskModal').classList.remove('hidden')" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">+ New Task</button>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50"><tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Title</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Assigned To</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Priority</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Due Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr></thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($tasks as $task)
                        <tr>
                            <td class="px-6 py-4"><div class="text-sm font-medium text-gray-900">{{ $task->title }}</div><div class="text-xs text-gray-500">{{ Str::limit($task->description, 40) }}</div></td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $task->assignee->name ?? 'Unassigned' }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $task->priority === 'urgent' ? 'bg-red-100 text-red-800' : ($task->priority === 'high' ? 'bg-orange-100 text-orange-800' : ($task->priority === 'medium' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">{{ ucfirst($task->priority) }}</span></td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $task->due_date?->format('M d, Y') ?? '-' }}</td>
                            <td class="px-6 py-4"><span class="px-2 text-xs rounded-full {{ $task->status === 'COMPLETED' ? 'bg-green-100 text-green-800' : ($task->status === 'IN_PROGRESS' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">{{ str_replace('_', ' ', $task->status) }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="px-6 py-4 text-center text-gray-500">No tasks found.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $tasks->withQueryString()->links() }}</div>
        </div>
    </div>

    <div id="addTaskModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium mb-4">New Task</h3>
            <form method="POST" action="{{ route('admin.tasks.store') }}" class="space-y-4">@csrf
                <div><label class="block text-sm font-medium text-gray-700">Title</label><input type="text" name="title" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700">Description</label><textarea name="description" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea></div>
                <div><label class="block text-sm font-medium text-gray-700">Assign To</label>
                    <select name="assigned_to" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="">Unassigned</option>
                        @foreach(\App\Models\User::orderBy('name')->get() as $user)<option value="{{ $user->id }}">{{ $user->name }}</option>@endforeach
                    </select>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div><label class="block text-sm font-medium text-gray-700">Priority</label><select name="priority" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="low">Low</option><option value="medium" selected>Medium</option><option value="high">High</option><option value="urgent">Urgent</option></select></div>
                    <div><label class="block text-sm font-medium text-gray-700">Due Date</label><input type="date" name="due_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                </div>
                <div class="flex justify-end space-x-2"><button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">Cancel</button><button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">Create</button></div>
            </form>
        </div>
    </div>
</x-admin-layout>
