<x-admin-layout>
    <x-slot name="header">Tax Management</x-slot>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        {{-- Tax Rates --}}
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Tax Rates</h3>
                    <button onclick="document.getElementById('addRateModal').classList.remove('hidden')" class="px-3 py-1 bg-blue-600 text-white text-sm rounded hover:bg-blue-700">+ Add Rate</button>
                </div>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Rate</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($rates as $rate)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $rate->name }}</td>
                                <td class="px-4 py-3 text-sm text-gray-500">{{ $rate->type }}</td>
                                <td class="px-4 py-3 text-sm font-medium text-gray-900">{{ $rate->rate }}%</td>
                                <td class="px-4 py-3"><span class="px-2 text-xs rounded-full {{ $rate->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $rate->is_active ? 'Active' : 'Inactive' }}</span></td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-3 text-center text-gray-500">No tax rates.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">{{ $rates->withQueryString()->links() }}</div>
            </div>
        </div>

        {{-- Tax Records --}}
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Tax Records</h3>
                    <button onclick="document.getElementById('addRecordModal').classList.remove('hidden')" class="px-3 py-1 bg-green-600 text-white text-sm rounded hover:bg-green-700">+ Add Record</button>
                </div>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Due</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse($records as $record)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $record->type }}</td>
                                <td class="px-4 py-3 text-sm text-gray-500">{{ $record->period }}</td>
                                <td class="px-4 py-3 text-sm font-medium">{{ number_format($record->amount, 2) }} EGP</td>
                                <td class="px-4 py-3 text-sm text-gray-500">{{ $record->due_date->format('M d, Y') }}</td>
                                <td class="px-4 py-3"><span class="px-2 text-xs rounded-full {{ $record->status === 'PAID' ? 'bg-green-100 text-green-800' : ($record->status === 'OVERDUE' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $record->status }}</span></td>
                            </tr>
                        @empty
                            <tr><td colspan="5" class="px-4 py-3 text-center text-gray-500">No tax records.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-4">{{ $records->withQueryString()->links() }}</div>
            </div>
        </div>
    </div>

    {{-- Add Rate Modal --}}
    <div id="addRateModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium mb-4">Add Tax Rate</h3>
            <form method="POST" action="{{ route('admin.tax.rates.store') }}" class="space-y-4">
                @csrf
                <div><label class="block text-sm font-medium text-gray-700">Name</label><input type="text" name="name" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700">Type</label>
                    <select name="type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="PERCENTAGE">Percentage</option><option value="FIXED">Fixed</option></select>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Rate (%)</label><input type="number" step="0.01" name="rate" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">Create</button>
                </div>
            </form>
        </div>
    </div>

    {{-- Add Record Modal --}}
    <div id="addRecordModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-medium mb-4">Add Tax Record</h3>
            <form method="POST" action="{{ route('admin.tax.records.store') }}" class="space-y-4">
                @csrf
                <div><label class="block text-sm font-medium text-gray-700">Type</label>
                    <select name="type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><option value="VAT">VAT</option><option value="INCOME_TAX">Income Tax</option><option value="SALES_TAX">Sales Tax</option><option value="WITHHOLDING">Withholding</option></select>
                </div>
                <div><label class="block text-sm font-medium text-gray-700">Period</label><input type="text" name="period" placeholder="e.g. Q1 2026" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700">Amount</label><input type="number" step="0.01" name="amount" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700">Due Date</label><input type="date" name="due_date" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded">Create</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>
