<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تعديل بيانات المستخدم: {{ $user->name }}</h2>
            <p class="text-slate-500 text-sm">تحديث المعلومات الشخصية والصلاحيات</p>
        </div>
        <a href="{{ route('admin.users.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-600 hover:bg-slate-50 hover:text-slate-800 transition-colors">
            <x-icon name="ArrowRight" class="h-4 w-4" />
            <span>إلغاء وعودة</span>
        </a>
    </div>

    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-8">
                <form method="POST" action="{{ route('admin.users.update', $user->id) }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <!-- Name -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-slate-700 mb-1">الاسم الكامل</label>
                        <input type="text" name="name" id="name" value="{{ old('name', $user->name) }}" required 
                               class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400">
                        @error('name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-slate-700 mb-1">البريد الإلكتروني</label>
                        <input type="email" name="email" id="email" value="{{ old('email', $user->email) }}" required 
                               class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400">
                         @error('email') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <!-- Phone -->
                    <div>
                        <label for="phone" class="block text-sm font-medium text-slate-700 mb-1">رقم الهاتف</label>
                        <input type="text" name="phone" id="phone" value="{{ old('phone', $user->phone) }}" 
                               class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400 text-right dir-ltr">
                         @error('phone') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <!-- Role -->
                    <div>
                        <label for="role" class="block text-sm font-medium text-slate-700 mb-1">الدور (الصلاحية)</label>
                        <select name="role" id="role" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                            <option value="customer" {{ old('role', $user->role) == 'customer' ? 'selected' : '' }}>عميل</option>
                            <option value="staff" {{ old('role', $user->role) == 'staff' ? 'selected' : '' }}>موظف</option>
                            <option value="manager" {{ old('role', $user->role) == 'manager' ? 'selected' : '' }}>مدير</option>
                            <option value="admin" {{ old('role', $user->role) == 'admin' ? 'selected' : '' }}>مدير النظام</option>
                        </select>
                         @error('role') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <!-- Is Active -->
                    <div>
                        <label for="is_active" class="block text-sm font-medium text-slate-700 mb-1">الحالة</label>
                        <select name="is_active" id="is_active" required class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500">
                            <option value="1" {{ old('is_active', $user->is_active) ? 'selected' : '' }}>نشط</option>
                            <option value="0" {{ !old('is_active', $user->is_active) ? 'selected' : '' }}>غير نشط</option>
                        </select>
                    </div>

                    <div class="border-t border-gray-100 pt-6 mt-6">
                        <h3 class="text-lg font-bold text-slate-800 mb-4 flex items-center gap-2">
                            <x-icon name="Lock" class="h-5 w-5 text-slate-400" />
                            تغيير كلمة المرور (اختياري)
                        </h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Password -->
                            <div>
                                <label for="password" class="block text-sm font-medium text-slate-700 mb-1">كلمة المرور الجديدة</label>
                                <input type="password" name="password" id="password" 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                       placeholder="••••••••">
                                 @error('password') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div>
                                <label for="password_confirmation" class="block text-sm font-medium text-slate-700 mb-1">تأكيد كلمة المرور</label>
                                <input type="password" name="password_confirmation" id="password_confirmation" 
                                       class="w-full rounded-xl border-gray-200 focus:border-blue-500 focus:ring-blue-500 placeholder-slate-400"
                                       placeholder="••••••••">
                            </div>
                        </div>
                    </div>

                    <div class="pt-6 border-t border-gray-100 flex items-center justify-end gap-3">
                        <button type="submit" class="inline-flex items-center gap-2 px-6 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors shadow-sm font-semibold">
                            <x-icon name="Check" class="h-4 w-4" />
                            <span>حفظ التعديلات</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin-layout>
