<x-admin-layout>
    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">تفاصيل المستخدم: {{ $user->name }}</h2>
            <p class="text-slate-500 text-sm">عرض المعلومات الشخصية للمستخدم والصلاحيات</p>
        </div>
        <a href="{{ route('admin.users.index') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-600 hover:bg-slate-50 hover:text-slate-800 transition-colors">
            <x-icon name="ArrowRight" class="h-4 w-4" />
            <span>عودة للقائمة</span>
        </a>
    </div>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="p-6 border-b border-gray-50 flex flex-col items-center text-center">
                <div class="h-24 w-24 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 mb-4 ring-4 ring-blue-50/50">
                    <span class="text-3xl font-bold">{{ substr($user->name, 0, 1) }}</span>
                </div>
                <h3 class="text-xl font-bold text-slate-800">{{ $user->name }}</h3>
                <p class="text-slate-500 text-sm mb-2">{{ $user->email }}</p>
                <div class="flex items-center justify-center mt-2">
                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full 
                        {{ $user->is_active ? 'bg-emerald-100 text-emerald-700' : 'bg-red-100 text-red-700' }}">
                        {{ $user->is_active ? 'نشط' : 'غير نشط' }}
                    </span>
                </div>
            </div>
            
            <div class="p-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="space-y-6">
                        <div class="bg-slate-50 p-4 rounded-xl">
                            <label class="text-xs text-slate-400 block mb-1 flex items-center gap-1">
                                <x-icon name="User" class="h-3 w-3" />
                                الاسم الكامل
                            </label>
                            <div class="text-slate-800 font-medium text-lg">{{ $user->name }}</div>
                        </div>
                        <div class="bg-slate-50 p-4 rounded-xl">
                            <label class="text-xs text-slate-400 block mb-1 flex items-center gap-1">
                                <x-icon name="Mail" class="h-3 w-3" />
                                البريد الإلكتروني
                            </label>
                            <div class="text-slate-800 font-medium">{{ $user->email }}</div>
                        </div>
                        <div class="bg-slate-50 p-4 rounded-xl">
                            <label class="text-xs text-slate-400 block mb-1 flex items-center gap-1">
                                <x-icon name="Phone" class="h-3 w-3" />
                                رقم الهاتف
                            </label>
                            <div class="text-slate-800 font-medium dir-ltr text-right">{{ $user->phone ?? 'غير متوفر' }}</div>
                        </div>
                    </div>
                    
                    <div class="space-y-6">
                        <div class="bg-slate-50 p-4 rounded-xl">
                            <label class="text-xs text-slate-400 block mb-1 flex items-center gap-1">
                                <x-icon name="Shield" class="h-3 w-3" />
                                الدور (الصلاحية)
                            </label>
                            <div class="text-slate-800 font-medium">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full bg-blue-100 text-blue-700 border border-blue-200">
                                    {{ $user->role === 'admin' ? 'مدير النظام' : ($user->role === 'manager' ? 'مدير' : ($user->role === 'staff' ? 'موظف' : 'عميل')) }}
                                </span>
                            </div>
                        </div>
                        <div class="bg-slate-50 p-4 rounded-xl">
                            <label class="text-xs text-slate-400 block mb-1 flex items-center gap-1">
                                <x-icon name="Calendar" class="h-3 w-3" />
                                تاريخ الانضمام
                            </label>
                            <div class="text-slate-800 font-medium">{{ $user->created_at->format('Y-m-d') }}</div>
                            <div class="text-xs text-slate-400 mt-1">{{ $user->created_at->diffForHumans() }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-gray-50/50 p-6 border-t border-gray-100 flex justify-end gap-3">
                <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا المستخدم؟');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 bg-red-50 text-red-600 rounded-xl hover:bg-red-100 transition-colors font-medium">
                        <x-icon name="Trash" class="h-4 w-4" />
                        <span>حذف المستخدم</span>
                    </button>
                </form>
                <a href="{{ route('admin.users.edit', $user->id) }}" class="inline-flex items-center gap-2 px-6 py-2 bg-blue-600 text-white rounded-xl hover:bg-blue-700 transition-colors font-semibold shadow-sm">
                    <x-icon name="Edit" class="h-4 w-4" />
                    <span>تعديل البيانات</span>
                </a>
            </div>
        </div>
    </div>
</x-admin-layout>
