<x-admin-layout>
    <x-slot name="header">
        Create New Vehicle
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <form method="POST" action="{{ route('admin.vehicles.store') }}" enctype="multipart/form-data">
            @csrf

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Basic Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Make -->
                        <div>
                            <label for="make" class="block text-sm font-medium text-gray-700">Make</label>
                            <input type="text" name="make" id="make" value="{{ old('make') }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Model -->
                        <div>
                            <label for="model" class="block text-sm font-medium text-gray-700">Model</label>
                            <input type="text" name="model" id="model" value="{{ old('model') }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Year -->
                        <div>
                            <label for="year" class="block text-sm font-medium text-gray-700">Year</label>
                            <input type="number" name="year" id="year" value="{{ old('year') }}" required min="1900" max="{{ date('Y') + 1 }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                         <!-- Stock Number -->
                        <div>
                            <label for="stock_number" class="block text-sm font-medium text-gray-700">Stock Number</label>
                            <input type="text" name="stock_number" id="stock_number" value="{{ old('stock_number') }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Stock Quantity -->
                        <div>
                            <label for="stock_quantity" class="block text-sm font-medium text-gray-700">Quantity</label>
                            <input type="number" name="stock_quantity" id="stock_quantity" value="{{ old('stock_quantity', 1) }}" required min="0" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- VIN -->
                        <div>
                            <label for="vin" class="block text-sm font-medium text-gray-700">VIN</label>
                            <div class="flex gap-2">
                                <input type="text" name="vin" id="vin" value="{{ old('vin') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <button type="button" onclick="decodeVin()" class="mt-1 px-3 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm">Decode</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script>
                async function decodeVin() {
                    const vin = document.getElementById('vin').value;
                    if (!vin) {
                        alert('Please enter a VIN first');
                        return;
                    }

                    try {
                        const response = await fetch('{{ route('admin.vehicles.decode-vin') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ vin: vin })
                        });

                        const data = await response.json();

                        if (data) {
                            if (data.make) document.getElementById('make').value = data.make;
                            if (data.model) document.getElementById('model').value = data.model;
                            if (data.year) document.getElementById('year').value = data.year;
                            if (data.fuel_type) document.querySelector(`select[name="fuel_type"]`).value = data.fuel_type.toUpperCase();
                            if (data.transmission) document.querySelector(`select[name="transmission"]`).value = data.transmission.toUpperCase();
                            if (data.color) document.querySelector(`select[name="color"]`) ? document.querySelector(`select[name="color"]`).value = data.color : null;
                        }
                    } catch (error) {
                        console.error('Error:', error);
                        alert('Failed to decode VIN');
                    }
                }
            </script>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Details & Pricing</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                         <!-- Price -->
                        <div>
                            <label for="price" class="block text-sm font-medium text-gray-700">Price (EGP)</label>
                            <input type="number" name="price" id="price" value="{{ old('price') }}" required step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Category -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700">Category</label>
                            <select name="category" id="category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="SEDAN">Sedan</option>
                                <option value="SUV">SUV</option>
                                <option value="TRUCK">Truck</option>
                                <option value="COUPE">Coupe</option>
                                <option value="VAN">Van</option>
                            </select>
                        </div>

                        <!-- Status -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AVAILABLE">Available</option>
                                <option value="SOLD">Sold</option>
                                <option value="RESERVED">Reserved</option>
                                <option value="MAINTENANCE">Maintenance</option>
                            </select>
                        </div>

                        <!-- Fuel Type -->
                        <div>
                            <label for="fuel_type" class="block text-sm font-medium text-gray-700">Fuel Type</label>
                             <select name="fuel_type" id="fuel_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="PETROL">Petrol</option>
                                <option value="DIESEL">Diesel</option>
                                <option value="ELECTRIC">Electric</option>
                                <option value="HYBRID">Hybrid</option>
                            </select>
                        </div>

                        <!-- Transmission -->
                        <div>
                            <label for="transmission" class="block text-sm font-medium text-gray-700">Transmission</label>
                             <select name="transmission" id="transmission" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AUTOMATIC">Automatic</option>
                                <option value="MANUAL">Manual</option>
                                <option value="CVT">CVT</option>
                            </select>
                        </div>

                        <!-- Mileage -->
                         <div>
                            <label for="mileage" class="block text-sm font-medium text-gray-700">Mileage (km)</label>
                            <input type="number" name="mileage" id="mileage" value="{{ old('mileage') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="mt-6">
                        <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('description') }}</textarea>
                    </div>
                </div>
            </div>

             <!-- Mock Images (Text URLs for now) -->
            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                 <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Images (URLs)</h3>
                    <div id="images-container" class="space-y-4">
                        <div class="flex space-x-2">
                             <input type="text" name="images[0][image_url]" placeholder="Image URL 1" class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                         <div class="flex space-x-2">
                             <input type="text" name="images[1][image_url]" placeholder="Image URL 2" class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>
                    <p class="mt-2 text-sm text-gray-500">Provide direct URLs to images.</p>
                </div>
            </div>

            <div class="flex justify-end">
                <a href="{{ route('admin.vehicles.index') }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-4">Cancel</a>
                <button type="submit" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Create Vehicle</button>
            </div>
        </form>
    </div>
</x-admin-layout>
