<x-admin-layout>
    <x-slot name="header">
        Edit Vehicle: {{ $vehicle->year }} {{ $vehicle->make }} {{ $vehicle->model }}
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <form method="POST" action="{{ route('admin.vehicles.update', $vehicle->id) }}">
            @csrf
            @method('PUT')

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Basic Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Make -->
                        <div>
                            <label for="make" class="block text-sm font-medium text-gray-700">Make</label>
                            <input type="text" name="make" id="make" value="{{ old('make', $vehicle->make) }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Model -->
                        <div>
                            <label for="model" class="block text-sm font-medium text-gray-700">Model</label>
                            <input type="text" name="model" id="model" value="{{ old('model', $vehicle->model) }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Year -->
                        <div>
                            <label for="year" class="block text-sm font-medium text-gray-700">Year</label>
                            <input type="number" name="year" id="year" value="{{ old('year', $vehicle->year) }}" required min="1900" max="{{ date('Y') + 1 }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                         <!-- Stock Number -->
                        <div>
                            <label for="stock_number" class="block text-sm font-medium text-gray-700">Stock Number</label>
                            <input type="text" name="stock_number" id="stock_number" value="{{ old('stock_number', $vehicle->stock_number) }}" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Stock Quantity -->
                        <div>
                            <label for="stock_quantity" class="block text-sm font-medium text-gray-700">Quantity</label>
                            <input type="number" name="stock_quantity" id="stock_quantity" value="{{ old('stock_quantity', $vehicle->stock_quantity) }}" required min="0" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- VIN -->
                        <div>
                            <label for="vin" class="block text-sm font-medium text-gray-700">VIN</label>
                            <input type="text" name="vin" id="vin" value="{{ old('vin', $vehicle->vin) }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Details & Pricing</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                         <!-- Price -->
                        <div>
                            <label for="price" class="block text-sm font-medium text-gray-700">Price (EGP)</label>
                            <input type="number" name="price" id="price" value="{{ old('price', $vehicle->pricing->price ?? 0) }}" required step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Category -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700">Category</label>
                            <select name="category" id="category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="SEDAN" {{ old('category', $vehicle->category) == 'SEDAN' ? 'selected' : '' }}>Sedan</option>
                                <option value="SUV" {{ old('category', $vehicle->category) == 'SUV' ? 'selected' : '' }}>SUV</option>
                                <option value="TRUCK" {{ old('category', $vehicle->category) == 'TRUCK' ? 'selected' : '' }}>Truck</option>
                                <option value="COUPE" {{ old('category', $vehicle->category) == 'COUPE' ? 'selected' : '' }}>Coupe</option>
                                <option value="VAN" {{ old('category', $vehicle->category) == 'VAN' ? 'selected' : '' }}>Van</option>
                            </select>
                        </div>

                        <!-- Status -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AVAILABLE" {{ old('status', $vehicle->status) == 'AVAILABLE' ? 'selected' : '' }}>Available</option>
                                <option value="SOLD" {{ old('status', $vehicle->status) == 'SOLD' ? 'selected' : '' }}>Sold</option>
                                <option value="RESERVED" {{ old('status', $vehicle->status) == 'RESERVED' ? 'selected' : '' }}>Reserved</option>
                                <option value="MAINTENANCE" {{ old('status', $vehicle->status) == 'MAINTENANCE' ? 'selected' : '' }}>Maintenance</option>
                            </select>
                        </div>

                        <!-- Fuel Type -->
                        <div>
                            <label for="fuel_type" class="block text-sm font-medium text-gray-700">Fuel Type</label>
                             <select name="fuel_type" id="fuel_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="PETROL" {{ old('fuel_type', $vehicle->fuel_type) == 'PETROL' ? 'selected' : '' }}>Petrol</option>
                                <option value="DIESEL" {{ old('fuel_type', $vehicle->fuel_type) == 'DIESEL' ? 'selected' : '' }}>Diesel</option>
                                <option value="ELECTRIC" {{ old('fuel_type', $vehicle->fuel_type) == 'ELECTRIC' ? 'selected' : '' }}>Electric</option>
                                <option value="HYBRID" {{ old('fuel_type', $vehicle->fuel_type) == 'HYBRID' ? 'selected' : '' }}>Hybrid</option>
                            </select>
                        </div>

                        <!-- Transmission -->
                        <div>
                            <label for="transmission" class="block text-sm font-medium text-gray-700">Transmission</label>
                             <select name="transmission" id="transmission" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AUTOMATIC" {{ old('transmission', $vehicle->transmission) == 'AUTOMATIC' ? 'selected' : '' }}>Automatic</option>
                                <option value="MANUAL" {{ old('transmission', $vehicle->transmission) == 'MANUAL' ? 'selected' : '' }}>Manual</option>
                                <option value="CVT" {{ old('transmission', $vehicle->transmission) == 'CVT' ? 'selected' : '' }}>CVT</option>
                            </select>
                        </div>

                        <!-- Mileage -->
                         <div>
                            <label for="mileage" class="block text-sm font-medium text-gray-700">Mileage (km)</label>
                            <input type="number" name="mileage" id="mileage" value="{{ old('mileage', $vehicle->mileage) }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="mt-6">
                        <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('description', $vehicle->description) }}</textarea>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <a href="{{ route('admin.vehicles.index') }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-4">Cancel</a>
                <button type="submit" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Update Vehicle</button>
            </div>
        </form>
    </div>
</x-admin-layout>
