<x-admin-layout>
    <x-slot name="header">
        Vehicle Details
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 flex justify-between items-center">
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900">{{ $vehicle->year }} {{ $vehicle->make }} {{ $vehicle->model }}</h3>
                    <p class="mt-1 max-w-2xl text-sm text-gray-500">{{ $vehicle->stock_number }}</p>
                </div>
                <div>
                     <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                        {{ $vehicle->status === 'AVAILABLE' ? 'bg-green-100 text-green-800' : 
                           ($vehicle->status === 'SOLD' ? 'bg-gray-100 text-gray-800' : 
                           ($vehicle->status === 'RESERVED' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800')) }}">
                        {{ $vehicle->status }}
                    </span>
                </div>
            </div>
            <div class="border-t border-gray-200 px-4 py-5 sm:p-0">
                <dl class="sm:divide-y sm:divide-gray-200">
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Price</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ number_format($vehicle->pricing->price ?? 0) }} EGP</dd>
                    </div>
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Category</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->category }}</dd>
                    </div>
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Stock Quantity</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->stock_quantity }}</dd>
                    </div>
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Mileage</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ number_format($vehicle->mileage ?? 0) }} km</dd>
                    </div>
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Fuel Type</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->fuel_type }}</dd>
                    </div>
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Transmission</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->transmission }}</dd>
                    </div>
                     <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">VIN</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->vin ?? 'N/A' }}</dd>
                    </div>
                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                        <dt class="text-sm font-medium text-gray-500">Description</dt>
                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">{{ $vehicle->description }}</dd>
                    </div>
                </dl>
            </div>
        </div>

        @if($vehicle->images->isNotEmpty())
        <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
            <div class="px-4 py-5 sm:px-6">
                 <h3 class="text-lg leading-6 font-medium text-gray-900">Images</h3>
            </div>
            <div class="px-4 py-5 sm:p-6">
                 <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    @foreach($vehicle->images as $image)
                        <div class="relative group">
                            <img src="{{ $image->image_url }}" alt="Vehicle Image" class="w-full h-32 object-cover rounded-lg">
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <div class="flex justify-end">
            <a href="{{ route('admin.vehicles.index') }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none mr-4">Back to List</a>
            <a href="{{ route('admin.vehicles.edit', $vehicle->id) }}" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none">Edit Vehicle</a>
        </div>
    </div>
</x-admin-layout>
