<x-auth-custom-layout>
    <div class="min-h-screen bg-gradient-to-br from-blue-900 to-blue-700 flex items-center justify-center p-4">
        <div class="w-full max-w-md">
            <!-- Logo and Brand -->
            <div class="text-center mb-8">
                <div class="flex items-center justify-center mb-4">
                    <x-icon name="Car" class="h-12 w-12 text-white" />
                </div>
                <h1 class="text-3xl font-bold text-white mb-2">الحمد للسيارات</h1>
                <p class="text-blue-100">لوحة تحكم المشرفين</p>
            </div>

            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="p-6 text-center border-b border-gray-100">
                    <div class="flex items-center justify-center mb-2">
                        <x-icon name="Shield" class="h-8 w-8 text-blue-600" />
                    </div>
                    <h2 class="text-2xl font-bold text-gray-900">تسجيل الدخول</h2>
                    <p class="text-gray-500 mt-1">
                        قم بتسجيل الدخول للوصول إلى حسابك
                    </p>
                </div>
                <div class="p-6">
                    <!-- Session Status -->
                    <x-auth-session-status class="mb-4" :status="session('status')" />
                    
                    <form method="POST" action="{{ route('login') }}" class="space-y-4">
                        @csrf

                        <!-- Email Address -->
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني</label>
                            <input id="email" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" placeholder="أدخل بريدك الإلكتروني" />
                            <x-input-error :messages="$errors->get('email')" class="mt-2" />
                        </div>

                        <!-- Password -->
                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور</label>
                            <div class="relative" x-data="{ show: false }">
                                <input id="password" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                :type="show ? 'text' : 'password'"
                                                name="password"
                                                required autocomplete="current-password"
                                                placeholder="أدخل كلمة المرور" />
                                <button type="button" @click="show = !show" class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400 hover:text-gray-600">
                                    <x-icon name="Eye" class="h-4 w-4" x-show="!show" />
                                    <x-icon name="EyeOff" class="h-4 w-4" x-show="show" style="display: none;" />
                                </button>
                            </div>
                            <x-input-error :messages="$errors->get('password')" class="mt-2" />
                        </div>

                        <!-- Remember Me -->
                        <div class="flex items-center justify-between">
                            <label for="remember_me" class="inline-flex items-center">
                                <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500" name="remember">
                                <span class="ms-2 text-sm text-gray-600">تذكرني</span>
                            </label>
                            
                            @if (Route::has('password.request'))
                                <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500" href="{{ route('password.request') }}">
                                    نسيت كلمة المرور؟
                                </a>
                            @endif
                        </div>

                        <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            تسجيل الدخول
                        </button>
                    </form>
                </div>
            </div>

            <div class="text-center mt-6 space-y-3">
                <a href="/" class="text-white hover:text-blue-200 block transition-colors">
                    العودة إلى الصفحة الرئيسية
                </a>
                <div class="text-sm text-blue-100">
                    <span>لا تمتلك حسابًا؟</span>
                    <a href="{{ route('register') }}" class="text-white hover:text-blue-200 font-bold ms-1 transition-colors">
                        قم بالتسجيل الآن
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-auth-custom-layout>
