<x-auth-custom-layout>
    <div class="min-h-screen bg-gradient-to-br from-blue-50 to-blue-100 flex items-center justify-center p-4">
        <div class="w-full max-w-md">
            <!-- Logo and Brand -->
            <div class="text-center mb-8">
                <div class="flex items-center justify-center mb-4">
                    <x-icon name="Car" class="h-12 w-12 text-blue-600" />
                </div>
                <h1 class="text-3xl font-bold text-gray-900 mb-2">Al-Hamd Cars</h1>
                <p class="text-gray-600">إنشاء حساب جديد</p>
            </div>

            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="p-6 border-b border-gray-100">
                    <h2 class="text-2xl font-bold text-center text-gray-900">إنشاء حساب</h2>
                    <p class="text-gray-500 text-center mt-1">
                        أنشئ حسابك للوصول إلى جميع خدماتنا
                    </p>
                </div>
                <div class="p-6">
                    <form method="POST" action="{{ route('register') }}" class="space-y-4">
                        @csrf

                        <!-- Name -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">الاسم الكامل *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <x-icon name="Users" class="h-4 w-4 text-gray-400" />
                                </div>
                                <input id="name" class="block w-full pr-10 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" placeholder="أدخل اسمك الكامل" />
                            </div>
                            <x-input-error :messages="$errors->get('name')" class="mt-2" />
                        </div>

                        <!-- Email Address -->
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <x-icon name="Mail" class="h-4 w-4 text-gray-400" />
                                </div>
                                <input id="email" class="block w-full pr-10 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" type="email" name="email" :value="old('email')" required autocomplete="username" placeholder="أدخل بريدك الإلكتروني" />
                            </div>
                            <x-input-error :messages="$errors->get('email')" class="mt-2" />
                        </div>



                        <!-- Password -->
                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور *</label>
                            <div class="relative" x-data="{ show: false }">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <x-icon name="Lock" class="h-4 w-4 text-gray-400" />
                                </div>
                                <input id="password" class="block w-full pr-10 pl-10 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                :type="show ? 'text' : 'password'"
                                                name="password"
                                                required autocomplete="new-password"
                                                placeholder="أدخل كلمة المرور" />
                                <button type="button" @click="show = !show" class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400 hover:text-gray-600">
                                    <x-icon name="Eye" class="h-4 w-4" x-show="!show" />
                                    <x-icon name="EyeOff" class="h-4 w-4" x-show="show" style="display: none;" />
                                </button>
                            </div>
                            <x-input-error :messages="$errors->get('password')" class="mt-2" />
                        </div>

                        <!-- Confirm Password -->
                        <div>
                            <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">تأكيد كلمة المرور *</label>
                            <div class="relative" x-data="{ show: false }">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <x-icon name="Lock" class="h-4 w-4 text-gray-400" />
                                </div>
                                <input id="password_confirmation" class="block w-full pr-10 pl-10 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                                :type="show ? 'text' : 'password'"
                                                name="password_confirmation" required autocomplete="new-password"
                                                placeholder="أعد إدخال كلمة المرور" />
                                <button type="button" @click="show = !show" class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400 hover:text-gray-600">
                                    <x-icon name="Eye" class="h-4 w-4" x-show="!show" />
                                    <x-icon name="EyeOff" class="h-4 w-4" x-show="show" style="display: none;" />
                                </button>
                            </div>
                            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                        </div>

                        <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            إنشاء حساب
                        </button>
                    </form>

                    <div class="mt-6 text-center">
                        <p class="text-sm text-gray-600">
                            لديك حساب بالفعل؟
                            <a href="{{ route('login') }}" class="text-blue-600 hover:text-blue-800 font-medium transition-colors">
                                تسجيل الدخول
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-auth-custom-layout>
