@props([
    'type' => 'default',
    'size' => 'sm',
    'label' => '',
    'dot' => false,
])

@php
$typeMap = [
    'default' => 'bg-gray-100 text-gray-800',
    'primary' => 'bg-blue-100 text-blue-800',
    'success' => 'bg-green-100 text-green-800',
    'warning' => 'bg-yellow-100 text-yellow-800',
    'danger' => 'bg-red-100 text-red-800',
    'info' => 'bg-cyan-100 text-cyan-800',
    'purple' => 'bg-purple-100 text-purple-800',
    'indigo' => 'bg-indigo-100 text-indigo-800',
    'pink' => 'bg-pink-100 text-pink-800',
    // Status-based
    'ACTIVE' => 'bg-green-100 text-green-800',
    'INACTIVE' => 'bg-gray-100 text-gray-800',
    'PENDING' => 'bg-yellow-100 text-yellow-800',
    'APPROVED' => 'bg-green-100 text-green-800',
    'REJECTED' => 'bg-red-100 text-red-800',
    'OPEN' => 'bg-blue-100 text-blue-800',
    'CLOSED' => 'bg-gray-100 text-gray-800',
    'PAID' => 'bg-green-100 text-green-800',
    'OVERDUE' => 'bg-red-100 text-red-800',
    'SENT' => 'bg-blue-100 text-blue-800',
    'DRAFT' => 'bg-gray-100 text-gray-800',
    'CONFIRMED' => 'bg-green-100 text-green-800',
    'CANCELLED' => 'bg-red-100 text-red-800',
    'COMPLETED' => 'bg-green-100 text-green-800',
    'IN_PROGRESS' => 'bg-blue-100 text-blue-800',
    'PRESENT' => 'bg-green-100 text-green-800',
    'ABSENT' => 'bg-red-100 text-red-800',
    'LATE' => 'bg-yellow-100 text-yellow-800',
    'DELIVERED' => 'bg-green-100 text-green-800',
    'SUBMITTED' => 'bg-blue-100 text-blue-800',
];
$sizeMap = [
    'xs' => 'px-1.5 py-0.5 text-[10px]',
    'sm' => 'px-2.5 py-0.5 text-xs',
    'md' => 'px-3 py-1 text-sm',
    'lg' => 'px-4 py-1.5 text-base',
];
$classes = ($typeMap[$type] ?? $typeMap['default']) . ' ' . ($sizeMap[$size] ?? $sizeMap['sm']);
@endphp

<span {{ $attributes->merge(['class' => "inline-flex items-center rounded-full font-medium {$classes}"]) }}>
    @if($dot)
        <svg class="mr-1.5 h-2 w-2" fill="currentColor" viewBox="0 0 8 8"><circle cx="4" cy="4" r="3"/></svg>
    @endif
    {{ $label ?: $slot }}
</span>
