@props([
    'type' => 'bar',
    'labels' => [],
    'datasets' => [],
    'height' => '300px',
    'id' => 'chart-' . uniqid(),
    'options' => [],
])

<div {{ $attributes->merge(['class' => 'bg-white rounded-lg shadow-sm p-6']) }}>
    @if(isset($header))
        <div class="mb-4">{{ $header }}</div>
    @endif
    <div style="height: {{ $height }}; position: relative;">
        <canvas id="{{ $id }}"></canvas>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    new Chart(document.getElementById('{{ $id }}'), {
        type: '{{ $type }}',
        data: {
            labels: @json($labels),
            datasets: @json($datasets),
        },
        options: Object.assign({
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { position: 'top', rtl: true } },
        }, @json($options)),
    });
});
</script>
@endpush
