@props([
    'title' => 'هل أنت متأكد؟',
    'message' => 'لا يمكن التراجع عن هذا الإجراء.',
    'confirmText' => 'تأكيد',
    'cancelText' => 'إلغاء',
    'action' => '',
    'method' => 'POST',
    'type' => 'danger',
])

@php
$btnClass = $type === 'danger' ? 'bg-red-600 hover:bg-red-700' : 'bg-blue-600 hover:bg-blue-700';
@endphp

<div x-data="{ open: false }">
    <div @click="open = true">{{ $trigger ?? $slot }}</div>

    <div x-show="open" x-transition class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" @click="open = false"></div>
            <div class="bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full relative" dir="rtl">
                <div class="p-6">
                    <div class="flex items-center gap-3 mb-4">
                        @if($type === 'danger')
                            <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100"><svg class="h-6 w-6 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg></div>
                        @endif
                        <div><h3 class="text-lg font-medium text-gray-900">{{ $title }}</h3><p class="text-sm text-gray-500 mt-1">{{ $message }}</p></div>
                    </div>
                </div>
                <div class="bg-gray-50 px-6 py-3 flex justify-end space-x-3 space-x-reverse">
                    <button type="button" @click="open = false" class="px-4 py-2 bg-white border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">{{ $cancelText }}</button>
                    <form method="POST" action="{{ $action }}" class="inline">@csrf @method($method)
                        <button type="submit" class="px-4 py-2 {{ $btnClass }} text-white rounded-md text-sm font-medium">{{ $confirmText }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
