@props([
    'headers' => [],
    'rows' => [],
    'striped' => true,
    'hoverable' => true,
    'emptyMessage' => 'لا توجد بيانات للعرض.',
    'paginator' => null,
])

<div {{ $attributes->merge(['class' => 'bg-white shadow rounded-lg overflow-hidden']) }}>
    @if(isset($header))
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center flex-wrap gap-2">
            {{ $header }}
        </div>
    @endif

    @if(isset($filters))
        <div class="px-6 py-3 bg-gray-50 border-b border-gray-200">{{ $filters }}</div>
    @endif

    @if(count($rows) === 0 && !isset($body))
        <div class="p-8 text-center text-gray-500">
            <svg class="mx-auto h-12 w-12 text-gray-300 mb-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/></svg>
            {{ $emptyMessage }}
        </div>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                @if(count($headers))
                    <thead class="bg-gray-50">
                        <tr>
                            @foreach($headers as $h)
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ $h }}</th>
                            @endforeach
                        </tr>
                    </thead>
                @endif
                <tbody class="bg-white divide-y divide-gray-200 {{ $striped ? '[&>tr:nth-child(even)]:bg-gray-50' : '' }} {{ $hoverable ? '[&>tr]:hover:bg-gray-100 [&>tr]:transition-colors' : '' }}">
                    @if(isset($body))
                        {{ $body }}
                    @else
                        @foreach($rows as $row)
                            <tr>
                                @foreach($row as $cell)
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $cell }}</td>
                                @endforeach
                            </tr>
                        @endforeach
                    @endif
                </tbody>
            </table>
        </div>
    @endif

    @if($paginator)
        <div class="px-6 py-3 border-t border-gray-200">{{ $paginator->links() }}</div>
    @endif
</div>
