@props([
    'name' => 'file',
    'accept' => '*/*',
    'multiple' => false,
    'label' => 'اسحب وأفلت الملفات هنا أو انقر للاختيار',
    'maxSize' => '10MB',
    'preview' => false,
])

<div x-data="{
    files: [],
    dragOver: false,
    handleFiles(fileList) {
        this.files = Array.from(fileList);
    },
    removeFile(index) {
        this.files.splice(index, 1);
        this.$refs.input.value = '';
    }
}" {{ $attributes->merge(['class' => 'w-full']) }}>
    <div class="border-2 border-dashed rounded-lg p-6 text-center transition-colors"
         :class="dragOver ? 'border-blue-500 bg-blue-50' : 'border-gray-300 hover:border-gray-400'"
         @dragover.prevent="dragOver = true"
         @dragleave.prevent="dragOver = false"
         @drop.prevent="dragOver = false; handleFiles($event.dataTransfer.files)">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/></svg>
        <p class="mt-2 text-sm text-gray-600">{{ $label }}</p>
        <p class="mt-1 text-xs text-gray-400">الحد الأقصى: {{ $maxSize }}</p>
        <label class="mt-3 inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm rounded-lg hover:bg-blue-700 cursor-pointer">
            <span>اختيار ملف</span>
            <input x-ref="input" type="file" name="{{ $name }}" accept="{{ $accept }}" {{ $multiple ? 'multiple' : '' }}
                   @change="handleFiles($event.target.files)" class="hidden">
        </label>
    </div>

    <template x-if="files.length > 0">
        <div class="mt-3 space-y-2">
            <template x-for="(file, index) in files" :key="index">
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div class="flex items-center gap-2 text-sm"><span>📄</span><span x-text="file.name"></span><span class="text-gray-400 text-xs" x-text="(file.size / 1024).toFixed(1) + ' KB'"></span></div>
                    <button type="button" @click="removeFile(index)" class="text-red-500 hover:text-red-700 text-sm">✕</button>
                </div>
            </template>
        </div>
    </template>
</div>
