@props([
    'value' => 0,
    'max' => 100,
    'color' => 'blue',
    'size' => 'md',
    'label' => null,
    'showPercent' => true,
])

@php
$percent = $max > 0 ? min(round(($value / $max) * 100), 100) : 0;
$colorMap = [
    'blue' => 'bg-blue-600', 'green' => 'bg-green-600', 'red' => 'bg-red-600', 'yellow' => 'bg-yellow-600',
    'purple' => 'bg-purple-600', 'indigo' => 'bg-indigo-600', 'pink' => 'bg-pink-600',
    'auto' => $percent >= 75 ? 'bg-green-600' : ($percent >= 40 ? 'bg-yellow-600' : 'bg-red-600'),
];
$sizeMap = ['sm' => 'h-1.5', 'md' => 'h-2.5', 'lg' => 'h-4'];
$barColor = $colorMap[$color] ?? $colorMap['blue'];
$barHeight = $sizeMap[$size] ?? $sizeMap['md'];
@endphp

<div {{ $attributes->merge(['class' => 'w-full']) }}>
    @if($label || $showPercent)
        <div class="flex justify-between mb-1">
            @if($label)<span class="text-sm font-medium text-gray-700">{{ $label }}</span>@endif
            @if($showPercent)<span class="text-sm font-medium text-gray-500">{{ $percent }}%</span>@endif
        </div>
    @endif
    <div class="w-full bg-gray-200 rounded-full {{ $barHeight }}">
        <div class="{{ $barColor }} {{ $barHeight }} rounded-full transition-all duration-500" style="width: {{ $percent }}%"></div>
    </div>
</div>
