<div x-data="{ 
    deferredPrompt: null,
    showInstall: false,
    install() {
        if (this.deferredPrompt) {
            this.deferredPrompt.prompt();
            this.deferredPrompt.userChoice.then((choiceResult) => {
                if (choiceResult.outcome === 'accepted') {
                    console.log('User accepted the install prompt');
                }
                this.deferredPrompt = null;
                this.showInstall = false;
            });
        }
    }
}" 
@beforeinstallprompt.window="
    event.preventDefault();
    deferredPrompt = event.detail;
    showInstall = true;
">
    <div x-show="showInstall" 
         x-transition
         class="fixed bottom-4 left-4 z-50 bg-white dark:bg-gray-800 p-4 rounded-lg shadow-lg border border-gray-200 dark:border-gray-700 flex items-center gap-4 max-w-sm">
        <div class="bg-blue-100 dark:bg-blue-900 p-2 rounded-full">
            <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
            </svg>
        </div>
        <div class="flex-1">
            <h3 class="font-bold text-gray-900 dark:text-gray-100">تثبيت التطبيق</h3>
            <p class="text-xs text-gray-500 dark:text-gray-400">ثبت التطبيق للوصول السريع</p>
        </div>
        <button @click="install()" class="px-3 py-1.5 bg-blue-600 hover:bg-blue-700 text-white text-sm font-bold rounded-md transition-colors">
            تثبيت
        </button>
        <button @click="showInstall = false" class="text-gray-400 hover:text-gray-500">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
        </button>
    </div>
</div>
