@props([
    'name' => 'search',
    'placeholder' => 'بحث...',
    'value' => '',
    'action' => null,
])

<form {{ $action ? "action={$action}" : '' }} method="GET" class="relative">
    <div class="relative">
        <svg class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/></svg>
        <input type="text" name="{{ $name }}" value="{{ $value ?: request($name) }}" placeholder="{{ $placeholder }}"
            {{ $attributes->merge(['class' => 'block w-full pr-10 pl-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-blue-500 focus:border-blue-500']) }}>
    </div>
</form>
