@props([
    'items' => [],
    'title' => null,
    'collapsible' => false,
])

<nav {{ $attributes->merge(['class' => 'bg-white shadow rounded-lg overflow-hidden']) }}>
    @if($title)
        <div class="px-4 py-3 border-b border-gray-200">
            <h3 class="text-sm font-semibold text-gray-500 uppercase tracking-wider">{{ $title }}</h3>
        </div>
    @endif

    <div class="py-2">
        @foreach($items as $item)
            @php
                $isActive = isset($item['active']) && $item['active'];
                $hasChildren = isset($item['children']) && count($item['children']) > 0;
            @endphp
            <div @if($hasChildren && $collapsible) x-data="{ open: {{ $isActive ? 'true' : 'false' }} }" @endif>
                <a href="{{ $item['url'] ?? '#' }}"
                   @if($hasChildren && $collapsible) @click.prevent="open = !open" @endif
                   class="flex items-center gap-3 px-4 py-2.5 text-sm transition-colors {{ $isActive ? 'bg-blue-50 text-blue-700 border-r-3 border-blue-600 font-medium' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900' }}">
                    @if(isset($item['icon']))<span class="flex-shrink-0">{!! $item['icon'] !!}</span>@endif
                    <span class="flex-1">{{ $item['label'] }}</span>
                    @if(isset($item['badge']))<span class="px-2 py-0.5 rounded-full text-xs bg-gray-100 text-gray-600">{{ $item['badge'] }}</span>@endif
                    @if($hasChildren && $collapsible)<svg :class="open && 'rotate-90'" class="w-4 h-4 text-gray-400 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>@endif
                </a>
                @if($hasChildren)
                    <div @if($collapsible) x-show="open" x-transition @endif class="pr-8">
                        @foreach($item['children'] as $child)
                            <a href="{{ $child['url'] ?? '#' }}" class="block px-4 py-2 text-sm {{ (isset($child['active']) && $child['active']) ? 'text-blue-700 font-medium' : 'text-gray-500 hover:text-gray-700' }}">{{ $child['label'] }}</a>
                        @endforeach
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</nav>
