@props([
    'title' => '',
    'value' => '0',
    'icon' => null,
    'color' => 'blue',
    'trend' => null,
    'trendValue' => null,
    'href' => null,
])

@php
$colorMap = [
    'blue' => ['bg' => 'bg-blue-50', 'text' => 'text-blue-600', 'border' => 'border-blue-500'],
    'green' => ['bg' => 'bg-green-50', 'text' => 'text-green-600', 'border' => 'border-green-500'],
    'red' => ['bg' => 'bg-red-50', 'text' => 'text-red-600', 'border' => 'border-red-500'],
    'yellow' => ['bg' => 'bg-yellow-50', 'text' => 'text-yellow-600', 'border' => 'border-yellow-500'],
    'purple' => ['bg' => 'bg-purple-50', 'text' => 'text-purple-600', 'border' => 'border-purple-500'],
    'indigo' => ['bg' => 'bg-indigo-50', 'text' => 'text-indigo-600', 'border' => 'border-indigo-500'],
    'pink' => ['bg' => 'bg-pink-50', 'text' => 'text-pink-600', 'border' => 'border-pink-500'],
    'gray' => ['bg' => 'bg-gray-50', 'text' => 'text-gray-600', 'border' => 'border-gray-500'],
];
$c = $colorMap[$color] ?? $colorMap['blue'];
@endphp

<{{ $href ? 'a href='.$href : 'div' }} {{ $attributes->merge(['class' => "bg-white rounded-xl shadow-sm p-6 border-b-4 {$c['border']} hover:shadow-md transition-shadow"]) }}>
    <div class="flex justify-between items-start">
        <div>
            <p class="text-sm font-medium text-gray-500">{{ $title }}</p>
            <h3 class="text-2xl font-bold text-gray-900 mt-1">{{ $value }}</h3>
            @if($trend)
                <p class="text-xs mt-1 {{ $trend === 'up' ? 'text-green-600' : 'text-red-600' }}">
                    {!! $trend === 'up' ? '↑' : '↓' !!} {{ $trendValue }}
                </p>
            @endif
        </div>
        @if($icon)
            <div class="p-3 rounded-lg {{ $c['bg'] }} {{ $c['text'] }}">
                {!! $icon !!}
            </div>
        @endif
    </div>
    @if(isset($footer))
        <div class="mt-3 pt-3 border-t border-gray-100 text-sm text-gray-500">{{ $footer }}</div>
    @endif
</{{ $href ? 'a' : 'div' }}>
